/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import org.geotools.appschema.util.IndexQueryUtils;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IndexQueryManager;
import org.geotools.data.complex.IndexedMappingFeatureIterator;
import org.geotools.data.complex.MappingFeatureIteratorFactory;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;

public class TotalIndexedMappingFeatureIterator
extends IndexedMappingFeatureIterator {
    public TotalIndexedMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter, Transaction transaction, IndexQueryManager indexModeProcessor) {
        super(store, mapping, query, unrolledFilter, transaction, indexModeProcessor);
    }

    private void initNextSourceIndexRound() {
        Query nextQuery = this.getNextSourceQuery();
        try {
            this.sourceIterator = MappingFeatureIteratorFactory.getInstance(this.store, this.mapping, nextQuery, this.unrolledFilter, this.transaction, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query getNextSourceQuery() {
        Query nextQuery = new Query(this.query);
        Filter idInFilter = IndexQueryUtils.buildIdInExpression(this.getNextSourceIdList(), this.mapping);
        nextQuery.setFilter(idInFilter);
        nextQuery.setStartIndex(Integer.valueOf(0));
        nextQuery.setMaxFeatures(Integer.MAX_VALUE);
        return nextQuery;
    }

    private void closeIndexIterator() {
        if (this.indexIterator == null) {
            return;
        }
        try {
            this.indexIterator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeSourceIterator() {
        if (this.sourceIterator == null) {
            return;
        }
        this.sourceIterator.close();
    }

    @Override
    public boolean hasNext() {
        if (this.sourceIterator == null || !this.sourceIterator.hasNext()) {
            if (this.getIndexIterator().hasNext()) {
                this.closeSourceIterator();
                this.initNextSourceIndexRound();
                return this.hasNext();
            }
            return false;
        }
        return this.sourceIterator.hasNext();
    }

    @Override
    public Feature next() {
        if (this.hasNext()) {
            return this.sourceIterator.next();
        }
        return null;
    }

    public void close() {
        this.closeIndexIterator();
        this.closeSourceIterator();
    }
}

