/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.TestData;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaDataAccessTest
extends AppSchemaTestSupport {
    Name targetName;
    FeatureType targetType;
    private AppSchemaDataAccess dataStore;
    FeatureTypeMapping mapping;

    @Before
    public void setUp() throws Exception {
        MemoryDataStore ds = AppSchemaDataAccessTest.createWaterSampleTestFeatures();
        this.targetType = TestData.createComplexWaterSampleType();
        UniqueNameFeatureTypeFactoryImpl tf = new UniqueNameFeatureTypeFactoryImpl();
        AttributeDescriptor targetFeature = tf.createAttributeDescriptor((AttributeType)this.targetType, this.targetType.getName(), 0, Integer.MAX_VALUE, true, null);
        this.targetName = targetFeature.getName();
        List<AttributeMapping> mappings = TestData.createMappingsColumnsAndValues(targetFeature);
        Name sourceName = TestData.WATERSAMPLE_TYPENAME;
        SimpleFeatureSource source = ds.getFeatureSource(sourceName);
        NamespaceSupport namespaces = new NamespaceSupport();
        this.mapping = new FeatureTypeMapping((FeatureSource)source, targetFeature, mappings, namespaces);
        this.dataStore = new AppSchemaDataAccess(Collections.singleton(this.mapping));
    }

    @After
    public void tearDown() throws Exception {
        DataAccessRegistry.unregisterAndDisposeAll();
    }

    @Test
    public void testGetTypeNames() throws IOException {
        Name[] typeNames = this.dataStore.getTypeNames();
        Assert.assertNotNull((Object)typeNames);
        Assert.assertEquals((long)1L, (long)typeNames.length);
        Assert.assertEquals((Object)this.targetName, (Object)typeNames[0]);
        List names = this.dataStore.getNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertEquals((Object)this.targetName, names.get(0));
    }

    @Test
    public void testTargetType() throws IOException {
        Assert.assertEquals((Object)this.targetType, (Object)this.dataStore.getSchema(this.targetName));
    }

    @Test
    public void testGetBounds() throws IOException {
        String namespaceUri = "http://online.socialchange.net.au";
        String localName = "RoadSegment";
        Name typeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"RoadSegment");
        URL configUrl = this.getClass().getResource("/test-data/roadsegments.xml");
        AppSchemaDataAccessDTO config = new XMLConfigDigester().parse(configUrl);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        this.dataStore = new AppSchemaDataAccess(mappings);
        FeatureSource source = this.dataStore.getFeatureSource(typeName);
        FeatureTypeMapping mapping = (FeatureTypeMapping)mappings.iterator().next();
        FeatureSource mappedSource = mapping.getSource();
        ReferencedEnvelope expected = this.getBounds(mappedSource);
        ReferencedEnvelope actual = this.getBounds(source);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private ReferencedEnvelope getBounds(FeatureSource source) {
        try {
            ReferencedEnvelope boundingBox = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            FeatureCollection features = source.getFeatures();
            try (FeatureIterator iterator = features.features();){
                while (iterator.hasNext()) {
                    Feature f = iterator.next();
                    boundingBox.include(f.getBounds());
                }
            }
            return boundingBox;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testGetFeatureReader() throws IOException {
        Feature complexFeature;
        FeatureSource access = this.dataStore.getFeatureSource(this.targetName);
        FeatureType type = access.getSchema();
        Assert.assertEquals((Object)this.targetType, (Object)type);
        FeatureCollection reader = access.getFeatures();
        Assert.assertNotNull((Object)reader);
        try (FeatureIterator features = reader.features();){
            Assert.assertTrue((boolean)features.hasNext());
            complexFeature = features.next();
            Assert.assertNotNull((Object)complexFeature);
            Assert.assertEquals((Object)this.targetType, (Object)complexFeature.getType());
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName expr = ff.property("measurement[1]");
        Object value = expr.evaluate((Object)complexFeature);
        Assert.assertNotNull((Object)value);
        expr = ff.property("measurement[1]/parameter");
        value = expr.evaluate((Object)complexFeature);
        Assert.assertNotNull((Object)value);
        expr = ff.property("measurement[1]/value");
        value = expr.evaluate((Object)complexFeature);
        Assert.assertNotNull((Object)value);
        expr = ff.property("measurement[2]/parameter");
        value = expr.evaluate((Object)complexFeature);
        Assert.assertNotNull((Object)value);
        expr = ff.property("measurement[2]/value");
        value = expr.evaluate((Object)complexFeature);
        Assert.assertNotNull((Object)value);
        expr = ff.property("measurement[3]/parameter");
        value = expr.evaluate((Object)complexFeature);
        Assert.assertNotNull((Object)value);
        expr = ff.property("measurement[3]/value");
        value = expr.evaluate((Object)complexFeature);
        Assert.assertNotNull((Object)value);
    }

    @Test
    public void testGetFeatureSource() throws IOException {
        FeatureSource complexSource = this.dataStore.getFeatureSource(this.targetName);
        Assert.assertNotNull((Object)complexSource);
        Assert.assertEquals((Object)this.targetType, (Object)complexSource.getSchema());
    }

    @Test
    public void testGetFeatureReaderQuery() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName property = ff.property("sample/measurement[1]/parameter");
        Literal literal = ff.literal((Object)"ph");
        PropertyIsEqualTo filterParameter = ff.equals((Expression)property, (Expression)literal);
        property = ff.property("sample/measurement[1]/value");
        literal = ff.literal((Object)3);
        PropertyIsEqualTo filterValue = ff.equals((Expression)property, (Expression)literal);
        And filter = ff.and((Filter)filterParameter, (Filter)filterValue);
        FeatureSource complexSource = this.dataStore.getFeatureSource(this.targetName);
        FeatureCollection features = complexSource.getFeatures((Filter)filter);
        try (FeatureIterator reader = features.features();){
            PropertyIsEqualTo equivalentSourceFilter = ff.equals((Expression)ff.property("ph"), (Expression)ff.literal((Object)3));
            FeatureCollection collection = this.mapping.getSource().getFeatures((Filter)equivalentSourceFilter);
            int count = 0;
            int expectedCount = collection.size();
            PropertyIsGreaterThan badFilter = ff.greater((Expression)ff.property("sample/measurement[1]/value"), (Expression)ff.literal((Object)3));
            while (reader.hasNext()) {
                Feature f = reader.next();
                Assert.assertNotNull((Object)f);
                Assert.assertTrue((boolean)filter.evaluate((Object)f));
                Assert.assertFalse((boolean)badFilter.evaluate((Object)f));
                ++count;
            }
            Assert.assertEquals((long)expectedCount, (long)count);
        }
    }

    @Test
    public void testWithConfig() throws Exception {
        String nsUri = "http://online.socialchange.net.au";
        String localName = "RoadSegment";
        NameImpl typeName = new NameImpl("http://online.socialchange.net.au", "RoadSegment");
        URL configUrl = this.getClass().getResource("/test-data/roadsegments.xml");
        AppSchemaDataAccessDTO config = new XMLConfigDigester().parse(configUrl);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        this.dataStore = new AppSchemaDataAccess(mappings);
        FeatureSource source = this.dataStore.getFeatureSource((Name)typeName);
        FeatureType type = source.getSchema();
        AttributeDescriptor node = (AttributeDescriptor)Types.descriptor((ComplexType)type, (Name)Types.typeName((String)"http://online.socialchange.net.au", (String)"the_geom"));
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"LineStringPropertyType", (Object)node.getType().getName().getLocalPart());
        Assert.assertNotNull((Object)Types.descriptor((ComplexType)type, (Name)Types.typeName((String)"http://online.socialchange.net.au", (String)"name")));
        Name ftNodeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"fromToNodes");
        Assert.assertNotNull((Object)Types.descriptor((ComplexType)type, (Name)ftNodeName));
        AttributeDescriptor descriptor = (AttributeDescriptor)Types.descriptor((ComplexType)type, (Name)ftNodeName);
        ComplexType fromToNodes = (ComplexType)descriptor.getType();
        Assert.assertFalse((boolean)descriptor.isNillable());
        Assert.assertTrue((boolean)fromToNodes.isIdentified());
        Name fromNodeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"fromNode");
        AttributeDescriptor fromNode = (AttributeDescriptor)Types.descriptor((ComplexType)fromToNodes, (Name)fromNodeName);
        Assert.assertNotNull((Object)fromNode);
        Name toNodeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"toNode");
        AttributeDescriptor toNode = (AttributeDescriptor)Types.descriptor((ComplexType)fromToNodes, (Name)toNodeName);
        Assert.assertNotNull((Object)fromNode);
        Assert.assertEquals(Point.class, (Object)fromNode.getType().getBinding());
        Assert.assertEquals(Point.class, (Object)toNode.getType().getBinding());
        FeatureCollection content = source.getFeatures();
        int count = DataUtilities.count((FeatureCollection)content);
        int expectedCount = 5;
        Assert.assertEquals((String)"feature count", (long)5L, (long)count);
        int expectedCount2 = 3;
        Query query = new Query();
        query.setMaxFeatures(3);
        FeatureCollection content2 = source.getFeatures(query);
        int count2 = DataUtilities.count((FeatureCollection)content2);
        Assert.assertEquals((String)"feature count", (long)3L, (long)count2);
    }

    public static MemoryDataStore createWaterSampleTestFeatures() throws Exception {
        MemoryDataStore dataStore = new MemoryDataStore();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(TestData.WATERSAMPLE_TYPENAME.getLocalPart());
        tb.add("watersampleid", String.class);
        tb.add("ph", Integer.class);
        tb.add("temp", Integer.class);
        tb.add("turbidity", Float.class);
        SimpleFeatureType type = tb.buildFeatureType();
        dataStore.createSchema(type);
        int NUM_FEATURES = 10;
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(type);
        for (int i = 0; i < 10; ++i) {
            String fid = type.getName().getLocalPart() + "." + i;
            fbuilder.add((Object)("watersample." + i));
            fbuilder.add((Object)i);
            fbuilder.add((Object)(10 + i));
            fbuilder.add((Object)Float.valueOf(i));
            SimpleFeature f = fbuilder.buildFeature(fid);
            dataStore.addFeature(f);
        }
        return dataStore;
    }
}

