/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AbstractStationsTest;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DefaultGeometryTest
extends AbstractStationsTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DefaultGeometryTest.loadDataAccesses();
    }

    @Test
    public void testDefaultGeometryMappingConfiguration() throws IOException {
        FeatureType ftWithDefaultGeom = stationsDataAccess.getSchema(STATION_FEATURE);
        Assert.assertNotNull((Object)ftWithDefaultGeom.getGeometryDescriptor());
        Assert.assertEquals((Object)"__DEFAULT_GEOMETRY__", (Object)ftWithDefaultGeom.getGeometryDescriptor().getLocalName());
        FeatureTypeMapping mappingDefaultGeom = stationsDataAccess.getMappingByName(STATION_FEATURE);
        Assert.assertNotNull((Object)mappingDefaultGeom);
        Assert.assertNotNull((Object)mappingDefaultGeom.getDefaultGeometryXPath());
        Assert.assertEquals((Object)"st:location/st:position", (Object)mappingDefaultGeom.getDefaultGeometryXPath());
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_FEATURE);
        Id filter = ff.id(new FeatureId[]{ff.featureId("st.1")});
        FeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)DefaultGeometryTest.size(fc));
        try (FeatureIterator it = fc.features();){
            Feature station1 = it.next();
            Assert.assertEquals((Object)"st.1", (Object)station1.getIdentifier().toString());
            GeometryAttribute defaultGeom = station1.getDefaultGeometryProperty();
            Assert.assertNotNull((Object)defaultGeom);
            Assert.assertNotNull((Object)defaultGeom.getValue());
            Assert.assertTrue((boolean)(defaultGeom.getValue() instanceof Point));
            Point point = (Point)defaultGeom.getValue();
            Assert.assertEquals((Object)"POINT (-1 1)", (Object)this.writer.write((Geometry)point));
        }
    }

    @Test
    public void testDefaultGeometryNone() throws IOException {
        FeatureTypeMapping mappingNoDefaultGeom = stationsDataAccess.getMappingByNameOrElement(STATION_NO_DEFAULT_GEOM_MAPPING);
        Assert.assertNotNull((Object)mappingNoDefaultGeom);
        Assert.assertNull((Object)mappingNoDefaultGeom.getDefaultGeometryXPath());
        FeatureType ftNoDefaultGeom = stationsDataAccess.getSchema(STATION_NO_DEFAULT_GEOM_MAPPING);
        Assert.assertNull((Object)ftNoDefaultGeom.getGeometryDescriptor());
    }

    @Test
    public void testDefaultGeometryOverride() throws IOException {
        FeatureTypeMapping mappingWithGeom = stationsDataAccess.getMappingByName(STATION_WITH_GEOM_FEATURE);
        Assert.assertNotNull((Object)mappingWithGeom);
        Assert.assertNull((Object)mappingWithGeom.getDefaultGeometryXPath());
        FeatureType ftWithGeom = stationsDataAccess.getSchema(STATION_WITH_GEOM_FEATURE);
        Assert.assertNotNull((Object)ftWithGeom.getGeometryDescriptor());
        Assert.assertEquals((Object)Types.typeName((String)"http://www.stations.org/1.0", (String)"geometry"), (Object)ftWithGeom.getGeometryDescriptor().getName());
        FeatureTypeMapping mappingDefaultGeomOverride = stationsDataAccess.getMappingByName(STATION_DEFAULT_GEOM_OVERRIDE_MAPPING);
        Assert.assertEquals((Object)mappingWithGeom.getTargetFeature().getName(), (Object)mappingDefaultGeomOverride.getTargetFeature().getName());
        Assert.assertNotNull((Object)mappingDefaultGeomOverride);
        Assert.assertEquals((Object)"st:location/st:position", (Object)mappingDefaultGeomOverride.getDefaultGeometryXPath());
        FeatureType ftDefaultGeomOverride = stationsDataAccess.getSchema(STATION_DEFAULT_GEOM_OVERRIDE_MAPPING);
        Assert.assertEquals((Object)ftWithGeom.getName(), (Object)ftDefaultGeomOverride.getName());
        Assert.assertNotNull((Object)ftDefaultGeomOverride.getGeometryDescriptor());
        Assert.assertEquals((Object)"__DEFAULT_GEOMETRY__", (Object)ftDefaultGeomOverride.getGeometryDescriptor().getLocalName());
    }

    @Test
    public void testDefaultGeometryInsideChainedFeatureType() throws IOException {
        FeatureTypeMapping mappingChained = stationsDataAccess.getMappingByName(STATION_WITH_MEASUREMENTS_FEATURE);
        Assert.assertNotNull((Object)mappingChained);
        Assert.assertEquals((Object)"st:measurements/ms:Measurement/ms:sampledArea/ms:SampledArea/ms:geometry", (Object)mappingChained.getDefaultGeometryXPath());
        FeatureType ftChained = stationsDataAccess.getSchema(STATION_WITH_MEASUREMENTS_FEATURE);
        Assert.assertNotNull((Object)ftChained.getGeometryDescriptor());
        Assert.assertEquals((Object)"__DEFAULT_GEOMETRY__", (Object)ftChained.getGeometryDescriptor().getLocalName());
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_WITH_MEASUREMENTS_FEATURE);
        Id filter = ff.id(new FeatureId[]{ff.featureId("st.1")});
        FeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)DefaultGeometryTest.size(fc));
        try (FeatureIterator it = fc.features();){
            Feature station1 = it.next();
            Assert.assertEquals((Object)"st.1", (Object)station1.getIdentifier().toString());
            GeometryAttribute defaultGeom = station1.getDefaultGeometryProperty();
            Assert.assertNotNull((Object)defaultGeom);
            Assert.assertNotNull((Object)defaultGeom.getValue());
            Assert.assertTrue((boolean)(defaultGeom.getValue() instanceof Polygon));
            Polygon poly = (Polygon)defaultGeom.getValue();
            Assert.assertEquals((Object)"POLYGON ((-2 2, 0 2, 0 -2, -2 -2, -2 2))", (Object)this.writer.write((Geometry)poly));
        }
    }

    @Test
    public void testDefaultGeometryWrongType() {
        try {
            DefaultGeometryTest.loadDataAccess("stationsDefaultGeometryWrongType.xml");
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
            IllegalArgumentException iae = (IllegalArgumentException)ex.getCause();
            Assert.assertEquals((Object)"Default geometry descriptor could not be found for type \"http://www.stations.org/1.0:Station\" at x-path \"st:location/st:name\"", (Object)iae.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Expected IllegalArgumentException to be thrown, but " + e.getClass().getName() + " was thrown instead"));
        }
    }

    @Test
    public void testDefaultGeometryNonExistentProperty() {
        try {
            DefaultGeometryTest.loadDataAccess("stationsDefaultGeometryNonExistentProperty.xml");
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
            IllegalArgumentException iae = (IllegalArgumentException)ex.getCause();
            Assert.assertEquals((Object)"Default geometry descriptor could not be found for type \"http://www.stations.org/1.0:Station\" at x-path \"st:location/st:notThere\"", (Object)iae.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Expected IllegalArgumentException to be thrown, but " + e.getClass().getName() + " was thrown instead"));
        }
    }

    @Test
    public void testDefaultGeometryMultipleValues() throws IOException {
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_MULTIPLE_GEOM_MAPPING);
        FeatureCollection fc = fs.getFeatures();
        try (FeatureIterator it = fc.features();){
            try {
                it.next();
            }
            catch (Exception ex) {
                Assert.assertNotNull((Object)ex.getCause());
                Assert.assertTrue((String)"Expected RuntimeException to be thrown", (boolean)(ex.getCause() instanceof RuntimeException));
                RuntimeException re = (RuntimeException)ex.getCause();
                Assert.assertEquals((Object)"Error setting default geometry value: multiple values were found", (Object)re.getMessage());
            }
        }
    }

    @Test
    public void testGMLEncodingProperties() throws IOException {
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_WITH_MEASUREMENTS_CODE_FEATURE);
        GMLConfiguration gml31Config = new GMLConfiguration();
        Encoder encoder = new Encoder((Configuration)gml31Config);
        Id filter = ff.id(new FeatureId[]{ff.featureId("st.1")});
        FeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)DefaultGeometryTest.size(fc));
        try (FeatureIterator it = fc.features();){
            Feature station1 = it.next();
            Assert.assertEquals((Object)"st.1", (Object)station1.getIdentifier().toString());
            Document dom = encoder.encodeAsDOM((Object)station1, GML.featureMember);
            List<Element> measurements = this.getElementsFromDocumentUsingXpath(dom, "//st:StationWithMeasurementCode/st:measurements");
            Assert.assertFalse((boolean)measurements.isEmpty());
            Assert.assertFalse((boolean)measurements.get(0).hasAttribute("codename"));
            measurements = this.getElementsFromDocumentUsingXpath(dom, "//st:StationWithMeasurementCode/st:measurements/ms:MeasurementCode");
            Assert.assertFalse((boolean)measurements.isEmpty());
            Assert.assertTrue((boolean)measurements.get(0).hasAttribute("codename"));
            Assert.assertFalse((boolean)measurements.get(0).hasAttribute("code"));
            List<Element> names = this.getElementsFromDocumentUsingXpath(dom, "//st:StationWithMeasurementCode/st:measurements/ms:MeasurementCode/ms:name");
            Assert.assertFalse((boolean)names.isEmpty());
            Assert.assertTrue((boolean)names.get(0).hasAttribute("code"));
        }
        catch (TransformerException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        STATIONS_SCHEMA_BASE = "/test-data/stations/";
    }
}

