/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.appschema.jdbc.NamespaceAwareAttributeRenameVisitor;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.xlink.XLINK;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;

public class NestedAttributeExpression
extends AttributeExpressionImpl {
    private NestedAttributeMapping rootMapping;
    private XPathUtil.StepList fullSteps;

    public NestedAttributeExpression(XPathUtil.StepList xpath, NestedAttributeMapping nestedMapping) {
        super(xpath.toString());
        this.rootMapping = nestedMapping;
        this.fullSteps = xpath;
    }

    public Object evaluate(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Feature)) {
            return null;
        }
        return this.getValues((Feature)object, this.rootMapping, this.fullSteps);
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> getValues(Feature feature, NestedAttributeMapping nestedMapping, XPathUtil.StepList steps) {
        void var10_18;
        FeatureTypeMapping nextFMapping;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            nextFMapping = nestedMapping.getFeatureTypeMapping(feature);
        }
        catch (IOException e) {
            nextFMapping = null;
        }
        if (nextFMapping == null) {
            if (nestedMapping.isConditional()) {
                return values;
            }
            throw new UnsupportedOperationException("FeatureTypeMapping not found for " + this.attPath + ". Please revise PropertyName in your filter!");
        }
        List<Object> nestedFeatures = new ArrayList<Feature>();
        if (nestedMapping.isSameSource()) {
            nestedFeatures = new ArrayList();
            nestedFeatures.add(feature);
        } else {
            try {
                nestedFeatures = this.getNestedFeatures(feature, nestedMapping, nextFMapping);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed evaluating filter expression: '" + this.attPath + "'. Caused by: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                return values;
            }
        }
        boolean isClientProperty = this.isClientProperty(steps);
        XPathUtil.StepList newSteps = null;
        if (isClientProperty && (newSteps = steps.subList(0, steps.size() - 1)).size() == 1) {
            for (Feature feature2 : nestedFeatures) {
                values.addAll(this.getClientProperties(nestedMapping, feature2));
            }
        }
        Name nextElementName = nextFMapping.getTargetFeature().getName();
        int n = -1;
        if (Types.equals((Name)nextElementName, (QName)((XPathUtil.Step)steps.get(0)).getName())) {
            boolean bl = false;
        } else {
            XPathUtil.Step elementNameStep = (XPathUtil.Step)steps.get(nestedMapping.getTargetXPath().size());
            if (Types.equals((Name)nextElementName, (QName)elementNameStep.getName())) {
                int n2 = nestedMapping.getTargetXPath().size();
                if (steps.size() > n2 + 1 && !((XPathUtil.Step)steps.get(n2 + 1)).isXmlAttribute()) {
                    void var10_17;
                    ++var10_17;
                }
            }
        }
        if (var10_18 > -1 && !(newSteps = steps.subList((int)var10_18, steps.size())).isEmpty()) {
            List<NestedAttributeMapping> nestedMappings = nextFMapping.getNestedMappings();
            if (!nestedMappings.isEmpty()) {
                for (NestedAttributeMapping mapping : nestedMappings) {
                    if (!newSteps.startsWith(mapping.getTargetXPath())) continue;
                    for (Feature feature3 : nestedFeatures) {
                        values.addAll(this.getValues(feature3, mapping, newSteps));
                    }
                }
            }
            if (isClientProperty) {
                newSteps = newSteps.subList(0, newSteps.size() - 1);
            }
            boolean isXlinkHref = isClientProperty && this.isXlinkHref(steps);
            List<AttributeMapping> attMappings = nextFMapping.getAttributeMappingsIgnoreIndex(newSteps);
            for (AttributeMapping attributeMapping : attMappings) {
                if (isClientProperty) {
                    if (isXlinkHref && attributeMapping instanceof NestedAttributeMapping) continue;
                    for (Feature feature4 : nestedFeatures) {
                        values.addAll(this.getClientProperties(attributeMapping, feature4));
                    }
                    continue;
                }
                for (Feature feature5 : nestedFeatures) {
                    values.add(this.getValue(attributeMapping.getSourceExpression(), feature5));
                }
            }
        }
        return values;
    }

    private boolean isXlinkHref(XPathUtil.StepList steps) {
        if (steps.isEmpty()) {
            return false;
        }
        return ((XPathUtil.Step)steps.get(steps.size() - 1)).getName().equals(XLINK.HREF);
    }

    private boolean isClientProperty(XPathUtil.StepList steps) {
        if (steps.isEmpty()) {
            return false;
        }
        return ((XPathUtil.Step)steps.get(steps.size() - 1)).isXmlAttribute();
    }

    private List<Object> getClientProperties(AttributeMapping attMapping, Feature f) {
        Object value;
        ArrayList<Object> values = new ArrayList<Object>();
        XPathUtil.Step lastStep = this.getLastStep();
        Expression exp = this.getClientPropertyExpression(attMapping, lastStep);
        if (exp != null && (value = this.getValue(exp, f)) != null) {
            values.add(value);
        }
        return values;
    }

    private XPathUtil.Step getLastStep() {
        return (XPathUtil.Step)this.fullSteps.get(this.fullSteps.size() - 1);
    }

    private List<Feature> getNestedFeatures(Feature root, NestedAttributeMapping nestedMapping, FeatureTypeMapping fMapping) throws IOException {
        Object fTypeName = nestedMapping.getNestedFeatureType(root);
        if (fTypeName == null || !(fTypeName instanceof Name)) {
            return null;
        }
        boolean hasSimpleFeatures = AppSchemaDataAccessRegistry.hasName((Name)fTypeName);
        Object val = this.getValue(nestedMapping.getSourceExpression(), root);
        if (val == null) {
            return null;
        }
        if (hasSimpleFeatures) {
            return nestedMapping.getInputFeatures(val, fMapping);
        }
        return nestedMapping.getFeatures(val, null, root, 0, null);
    }

    private Object getValue(Expression expression, Feature feature) {
        try {
            Object value = expression.evaluate((Object)feature);
            return this.extractAttributeValue(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Object extractAttributeValue(Object value) {
        if (value == null) {
            return null;
        }
        while (value instanceof Attribute) {
            value = ((Attribute)value).getValue();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return null;
            }
            value = ((Collection)value).iterator().next();
            while (value instanceof Attribute) {
                value = ((Attribute)value).getValue();
            }
        }
        return value;
    }

    private Expression getClientPropertyExpression(AttributeMapping mapping, XPathUtil.Step lastStep) {
        Object exp = null;
        if (lastStep.isXmlAttribute()) {
            Name lastStepName;
            Map<Name, Expression> clientProperties = mapping.getClientProperties();
            QName lastStepQName = lastStep.getName();
            if (lastStepQName.getPrefix() != null && lastStepQName.getPrefix().length() > 0 && (lastStepQName.getNamespaceURI() == null || lastStepQName.getNamespaceURI().length() == 0)) {
                String prefix = lastStepQName.getPrefix();
                String uri = this.namespaceSupport.getURI(prefix);
                lastStepName = Types.typeName((String)uri, (String)lastStepQName.getLocalPart());
            } else {
                lastStepName = Types.toTypeName((QName)lastStepQName);
            }
            if (clientProperties.containsKey(lastStepName)) {
                exp = clientProperties.get(lastStepName);
            } else if (XPath.isId(lastStep)) {
                exp = mapping.getIdentifierExpression() == Expression.NIL ? CommonFactoryFinder.getFilterFactory(null).property("@id") : mapping.getIdentifierExpression();
            }
        }
        return exp;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        if (visitor instanceof DuplicatingFilterVisitor && !(visitor instanceof NamespaceAwareAttributeRenameVisitor)) {
            return new NestedAttributeExpression(this.fullSteps, this.rootMapping);
        }
        return visitor.visit((PropertyName)this, extraData);
    }
}

