/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IndexQueryManager;
import org.geotools.data.complex.IndexedMappingFeatureIterator;
import org.geotools.data.complex.MappingFeatureIteratorFactory;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class PartialIndexedMappingFeatureIterator
extends IndexedMappingFeatureIterator {
    private int maxNumRound = 100;
    private int sourceFeaturesCounter = 0;
    private IndexQueryManager.PartialIndexQueryManager partialIQM;
    private boolean skipped = false;

    public PartialIndexedMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter, Transaction transaction, IndexQueryManager indexModeProcessor) {
        this(store, mapping, query, unrolledFilter, transaction, indexModeProcessor, 100);
    }

    public PartialIndexedMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter, Transaction transaction, IndexQueryManager indexModeProcessor, int maxNumRound) {
        super(store, mapping, query, unrolledFilter, transaction, indexModeProcessor);
        this.maxNumRound = maxNumRound;
        this.partialIQM = new IndexQueryManager.PartialIndexQueryManager(mapping, query);
    }

    @Override
    protected Query transformQueryToIdsOnly() {
        Query idsQuery = new Query(this.unrollIndexes(this.partialIQM.getIndexQuery()));
        idsQuery.setProperties(this.getIndexQueryProperties());
        idsQuery.setTypeName(((SimpleFeatureType)this.mapping.getIndexSource().getSchema()).getTypeName());
        idsQuery.setStartIndex(null);
        idsQuery.setMaxFeatures(Integer.MAX_VALUE);
        return idsQuery;
    }

    private List<String> getNextIdList() {
        ArrayList<String> result = new ArrayList<String>();
        for (int count = 0; this.getIndexIterator().hasNext() && count < this.maxNumRound; ++count) {
            result.add((String)this.getIndexIterator().next());
        }
        return result;
    }

    private void nextSourceIteratorInstance() {
        List<String> ids = this.getNextIdList();
        Query nextQuery = this.partialIQM.buildCombinedQuery(ids);
        nextQuery.setStartIndex(null);
        nextQuery.setMaxFeatures(Integer.MAX_VALUE);
        try {
            this.sourceIterator = MappingFeatureIteratorFactory.getInstance(this.store, this.mapping, nextQuery, this.unrolledFilter, this.transaction, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeIndexIterator() {
        if (this.indexIterator == null) {
            return;
        }
        try {
            this.indexIterator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeSourceIterator() {
        if (this.sourceIterator == null) {
            return;
        }
        this.sourceIterator.close();
    }

    private boolean fastForward(int start) {
        while (this.sourceFeaturesCounter < start) {
            if (this.hasNext()) {
                this.next();
                continue;
            }
            return false;
        }
        return this.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (this.sourceIterator != null && this.sourceIterator.hasNext()) {
            int start;
            int n = start = this.query.getStartIndex() != null ? this.query.getStartIndex() : 0;
            if (this.sourceFeaturesCounter >= start + this.query.getMaxFeatures()) {
                return false;
            }
            if (this.sourceFeaturesCounter < start && !this.skipped) {
                this.skipped = true;
                return this.fastForward(start);
            }
            return true;
        }
        if (this.sourceIterator == null || !this.sourceIterator.hasNext()) {
            this.closeSourceIterator();
            if (this.getIndexIterator().hasNext()) {
                this.nextSourceIteratorInstance();
                return this.hasNext();
            }
            return false;
        }
        return false;
    }

    @Override
    public Feature next() {
        if (this.hasNext()) {
            ++this.sourceFeaturesCounter;
            return this.sourceIterator.next();
        }
        return null;
    }

    public void close() {
        this.closeSourceIterator();
        this.closeIndexIterator();
    }
}

