/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.commons.jxpath.JXPathException;
import org.geotools.appschema.feature.AppSchemaAttributeBuilder;
import org.geotools.appschema.util.XmlXpathUtilites;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeCreateOrderList;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.PathAttributeList;
import org.geotools.data.complex.XmlFeatureTypeMapping;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.complex.xml.XmlFeatureCollection;
import org.geotools.data.complex.xml.XmlResponse;
import org.geotools.data.complex.xml.XmlXpathFilterData;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.xml.sax.Attributes;

public class XmlMappingFeatureIterator
extends DataAccessMappingFeatureIterator {
    public static final String XPATH_SEPARATOR = "/";
    private static final String XPATH_LEFT_INDEX_BRACKET = "[";
    private static final String XPATH_RIGHT_INDEX_BRACKET = "]";
    protected XmlResponse xmlResponse;
    private AttributeCreateOrderList attOrderedTypeList = null;
    private int count = 0;
    private int indexCounter = 1;
    private String idXpath;

    public XmlMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        super(store, mapping, query, null, false);
        this.setIdXPath();
        if (this.xmlResponse == null) {
            this.xmlResponse = ((XmlFeatureCollection)this.sourceFeatures).xmlResponse();
        }
        List<Integer> ls = this.xmlResponse.getValidFeatureIndex();
        this.count = ls.size();
    }

    public XmlMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, String xpath, String value) throws IOException {
        super(store, mapping, query, null, false);
        this.setIdXPath();
        if (this.xmlResponse == null) {
            this.xmlResponse = ((XmlFeatureCollection)this.sourceFeatures).xmlResponse(xpath, value);
        }
        List<Integer> ls = this.xmlResponse.getValidFeatureIndex();
        this.count = ls.size();
    }

    private void setIdXPath() {
        this.idXpath = this.mapping.getFeatureIdExpression().equals(Expression.NIL) ? "@id" : this.mapping.getFeatureIdExpression().toString();
    }

    @Override
    protected FeatureIterator<? extends Feature> getSourceFeatureIterator() {
        return null;
    }

    @Override
    protected boolean isSourceFeatureIteratorNull() {
        return this.xmlResponse == null;
    }

    @Override
    protected String extractIdForAttribute(Expression idExpression, Object sourceInstance) {
        try {
            if (idExpression instanceof Function) {
                XmlXpathFilterData data = new XmlXpathFilterData(this.namespaces, this.xmlResponse.getDoc(), -1, XmlMappingFeatureIterator.createIndexedItemXpathString((XmlFeatureTypeMapping)this.mapping, this.xmlResponse, this.indexCounter));
                Object value = idExpression.evaluate((Object)data);
                return value == null ? "" : value.toString();
            }
            return XmlXpathUtilites.getSingleXPathValue(this.mapping.getNamespaces(), XmlMappingFeatureIterator.createIndexedItemXpathString((XmlFeatureTypeMapping)this.mapping, this.xmlResponse, this.indexCounter) + XPATH_SEPARATOR + this.idXpath, this.xmlResponse.getDoc());
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof JXPathException)) {
                throw e;
            }
            LOGGER.info("Feature id is not mapped for: " + String.valueOf(this.mapping.getTargetFeature().getName()));
            return null;
        }
    }

    public static String createIndexedItemXpathString(XmlFeatureTypeMapping mapping, XmlResponse xmlResponse, int indexCounter) {
        String rootXpath = mapping.itemXpath + XPATH_LEFT_INDEX_BRACKET + String.valueOf(xmlResponse.getValidFeatureIndex().get(indexCounter - 1)) + XPATH_RIGHT_INDEX_BRACKET;
        if (mapping.rootAttribute.getInstanceXpath() != null) {
            rootXpath = rootXpath + XPATH_SEPARATOR + mapping.rootAttribute.getInstanceXpath();
        }
        return rootXpath;
    }

    protected Feature populateFeatureData() throws IOException {
        AttributeDescriptor targetNode = this.mapping.getTargetFeature();
        AppSchemaAttributeBuilder builder = new AppSchemaAttributeBuilder(this.attf);
        builder.setDescriptor(targetNode);
        Feature target = (Feature)builder.build(this.extractIdForAttribute(this.mapping.getFeatureIdExpression(), null));
        if (this.attOrderedTypeList == null) {
            this.initialiseAttributeLists(this.mapping.getAttributeMappings());
        }
        PathAttributeList elements = this.populateAttributeList(target);
        this.setAttributeValues(elements, target);
        ++this.indexCounter;
        return target;
    }

    private void setAttributeValues(PathAttributeList elements, Feature target) throws IOException {
        for (AttributeMapping attMapping : ((XmlFeatureTypeMapping)this.mapping).setterAttributes) {
            String parentLabel = attMapping.getParentLabel();
            List<PathAttributeList.Pair> ls = elements.get(parentLabel);
            if (ls == null) continue;
            Expression sourceExpression = attMapping.getSourceExpression();
            Expression idExpression = attMapping.getIdentifierExpression();
            for (int i = 0; i < ls.size(); ++i) {
                PathAttributeList.Pair parentPair = ls.get(i);
                Attribute setterTarget = parentPair.getAttribute();
                XPathUtil.StepList xpath = attMapping.getTargetXPath().clone();
                Object value = this.getValue(parentPair.getXpath(), sourceExpression, (Attribute)target);
                ((XPathUtil.Step)xpath.get(0)).setIndex(i + 1);
                if (value == null) continue;
                if (value instanceof Collection) {
                    Collection values = (Collection)value;
                    for (Object val : values) {
                        this.setValues(val, setterTarget, parentPair, attMapping, target, xpath, idExpression);
                    }
                    continue;
                }
                this.setValues(value, setterTarget, parentPair, attMapping, target, xpath, idExpression);
            }
        }
    }

    private void setValues(Object value, Attribute setterTarget, PathAttributeList.Pair parentPair, AttributeMapping attMapping, Feature target, XPathUtil.StepList xpath, Expression idExpression) throws IOException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("setting target=" + String.valueOf(setterTarget.getName()) + ", targetXpath=" + String.valueOf(attMapping.getTargetXPath()) + ", value=" + String.valueOf(value));
        }
        String featureId = this.getId(idExpression, parentPair, attMapping, "");
        Attribute att = this.setAttributeValue((Attribute)target, featureId, null, attMapping, value, xpath, null);
        this.setClientProperties(att, parentPair.getXpath(), attMapping.getClientProperties());
    }

    private void setMappedIndex(Attribute att, int index) {
        att.getUserData().put("MAPPED_ATTRIBUTE_INDEX", index);
    }

    @Override
    protected void setClientProperties(Attribute target, Object xpathPrefix, Map<Name, Expression> clientProperties) {
        if (target == null) {
            return;
        }
        HashMap<Name, Object> targetAttributes = new HashMap<Name, Object>();
        if (target.getUserData().containsValue(Attributes.class)) {
            Map map = (Map)target.getUserData().get(Attributes.class);
            targetAttributes.putAll(map);
        }
        for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
            Name propName = entry.getKey();
            Expression propExpr = entry.getValue();
            Object propValue = propExpr instanceof Expression ? this.getValue(xpathPrefix == null ? "" : xpathPrefix.toString(), propExpr, target) : propExpr;
            if (propValue == null) continue;
            if (propValue instanceof Collection) {
                if (((Collection)propValue).isEmpty()) continue;
                propValue = ((Collection)propValue).iterator().next();
                targetAttributes.put(propName, propValue);
                continue;
            }
            targetAttributes.put(propName, propValue);
        }
        if (!targetAttributes.isEmpty()) {
            target.getUserData().put(Attributes.class, targetAttributes);
        }
        this.setGeometryUserData(target, targetAttributes);
    }

    private String bracketedIndex(int j) {
        return XPATH_LEFT_INDEX_BRACKET + Integer.toString(j) + XPATH_RIGHT_INDEX_BRACKET;
    }

    private PathAttributeList populateAttributeList(Feature target) throws IOException {
        PathAttributeList elements = new PathAttributeList();
        String rootPrefix = XmlMappingFeatureIterator.createIndexedItemXpathString((XmlFeatureTypeMapping)this.mapping, this.xmlResponse, this.indexCounter);
        elements.put(((XmlFeatureTypeMapping)this.mapping).rootAttribute.getLabel(), rootPrefix, (Attribute)target);
        this.setClientProperties((Attribute)target, rootPrefix, ((XmlFeatureTypeMapping)this.mapping).rootAttribute.getClientProperties());
        Iterator<AttributeMapping> it = this.attOrderedTypeList.iterator();
        while (it.hasNext()) {
            AttributeMapping attMapping = it.next();
            Expression idExpression = attMapping.getIdentifierExpression();
            List<PathAttributeList.Pair> ls = elements.get(attMapping.getParentLabel());
            if (ls == null) continue;
            for (PathAttributeList.Pair parentAttribute : ls) {
                Object countXpath = parentAttribute.getXpath();
                if (attMapping.getInstanceXpath() != null) {
                    countXpath = (String)countXpath + XPATH_SEPARATOR + attMapping.getInstanceXpath();
                }
                int count = XmlXpathUtilites.countXPathNodes(this.mapping.getNamespaces(), (String)countXpath, this.xmlResponse.getDoc());
                this.createSubFeaturesAndAddToAttributeList(elements, attMapping, idExpression, parentAttribute, count, (String)countXpath, target);
            }
        }
        return elements;
    }

    private String getId(Expression idExpression, PathAttributeList.Pair parentAttribute, AttributeMapping attMapping, String bracketIndex) {
        String featureId = null;
        if (idExpression instanceof Function) {
            String idPath = parentAttribute.getXpath() + XPATH_SEPARATOR;
            if (attMapping.getInstanceXpath() != null) {
                idPath = idPath + attMapping.getInstanceXpath() + bracketIndex;
            }
            XmlXpathFilterData data = new XmlXpathFilterData(this.namespaces, this.xmlResponse.getDoc(), -1, idPath);
            featureId = (String)idExpression.evaluate((Object)data, String.class);
        } else {
            String idPath = this.setFeatureXpath(attMapping, idExpression, parentAttribute, bracketIndex);
            List<String> featureIdList = this.getValue(idPath);
            if (!featureIdList.isEmpty()) {
                featureId = featureIdList.get(0);
            }
        }
        return featureId;
    }

    private void createSubFeaturesAndAddToAttributeList(PathAttributeList elements, AttributeMapping attMapping, Expression idExpression, PathAttributeList.Pair parentAttribute, int count, String countXpath, Feature target) throws IOException {
        XPathUtil.StepList sl = attMapping.getTargetXPath().clone();
        this.setPathIndex(parentAttribute.getAttribute(), sl);
        for (int j = 1; j <= count; ++j) {
            String bracketIndex = this.bracketedIndex(j);
            String featureId = this.getId(idExpression, parentAttribute, attMapping, bracketIndex);
            this.setLastElementIndex(parentAttribute.getAttribute(), sl, j);
            Attribute subFeature = this.xpathAttributeBuilder.set((Attribute)target, sl, null, featureId, attMapping.getTargetNodeInstance(), false, attMapping.getSourceExpression());
            String xpath = countXpath + bracketIndex;
            this.setClientProperties(subFeature, xpath, attMapping.getClientProperties());
            this.setMappedIndex(subFeature, j);
            elements.put(attMapping.getLabel(), xpath, subFeature);
        }
    }

    private void setLastElementIndex(Attribute parent, XPathUtil.StepList sl, int index) {
        if (!(parent.getType() instanceof ComplexTypeImpl)) {
            ((XPathUtil.Step)sl.get(0)).setIndex(index);
            return;
        }
        ComplexTypeImpl type = (ComplexTypeImpl)parent.getType();
        int lastIndex = sl.size() - 1;
        Name lastStep = Types.toTypeName((QName)((XPathUtil.Step)sl.get(lastIndex)).getName());
        while (!Types.isElement((ComplexType)type, (Name)lastStep)) {
            if (--lastIndex < 0) {
                return;
            }
            lastStep = Types.toTypeName((QName)((XPathUtil.Step)sl.get(lastIndex)).getName());
        }
        ((XPathUtil.Step)sl.get(lastIndex)).setIndex(index);
    }

    private String setFeatureXpath(AttributeMapping attMapping, Expression sourceExpression, PathAttributeList.Pair parentAttribute, String bracketIndex) {
        String xpath = attMapping.getInstanceXpath() == null ? parentAttribute.getXpath() + XPATH_SEPARATOR + sourceExpression.toString() : parentAttribute.getXpath() + XPATH_SEPARATOR + attMapping.getInstanceXpath() + bracketIndex + XPATH_SEPARATOR + sourceExpression.toString();
        return xpath;
    }

    private void setPathIndex(Attribute att, XPathUtil.StepList sl) {
        Object index = att.getUserData().get("MAPPED_ATTRIBUTE_INDEX");
        if (index != null) {
            int mappedIndex = Integer.parseInt(String.valueOf(index));
            Name attName = att.getName();
            String nsPrefix = this.namespaces.getPrefix(attName.getNamespaceURI());
            String xpath = nsPrefix + ":" + attName.getLocalPart();
            sl.setIndex(mappedIndex, xpath, XPATH_SEPARATOR);
        }
    }

    @Override
    protected boolean unprocessedFeatureExists() {
        return this.indexCounter <= this.count;
    }

    @Override
    protected boolean sourceFeatureIteratorHasNext() {
        return this.indexCounter <= this.count;
    }

    @Override
    protected boolean isNextSourceFeatureNull() {
        return this.indexCounter > this.count;
    }

    private Object getValue(String xpathPrefix, Expression node, Attribute target) {
        boolean isUnsetNode;
        String EMPTY_STRING = "";
        Object expressionString = node.toString();
        boolean bl = isUnsetNode = Expression.NIL.equals(node) || ((String)expressionString).equals("''");
        if (isUnsetNode || ((String)expressionString).startsWith("'") || node instanceof LiteralExpressionImpl) {
            String editedValue = "";
            if (!isUnsetNode) {
                editedValue = ((String)expressionString).replace("'", "");
            }
            return editedValue;
        }
        if (node instanceof Function) {
            XmlXpathFilterData data = new XmlXpathFilterData(this.namespaces, this.xmlResponse.getDoc(), -1, xpathPrefix);
            return node.evaluate((Object)data);
        }
        if (xpathPrefix.length() > 0) {
            expressionString = xpathPrefix + XPATH_SEPARATOR + (String)expressionString;
        }
        return this.getValue((String)expressionString);
    }

    protected List<String> getValue(String expressionValue) {
        return XmlXpathUtilites.getXPathValues(this.mapping.getNamespaces(), expressionValue, this.xmlResponse.getDoc());
    }

    @Override
    protected void closeSourceFeatures() {
        if (this.sourceFeatures != null) {
            this.xmlResponse = null;
            this.sourceFeatures = null;
        }
    }

    private void initialiseAttributeLists(List<AttributeMapping> mappings) {
        this.attOrderedTypeList = new AttributeCreateOrderList(((XmlFeatureTypeMapping)this.mapping).rootAttribute.getLabel());
        for (AttributeMapping attMapping : mappings) {
            if (attMapping.equals(((XmlFeatureTypeMapping)this.mapping).rootAttribute) || attMapping.getLabel() == null || attMapping.getParentLabel() == null) continue;
            this.attOrderedTypeList.put(attMapping);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.isHasNextCalled()) {
            return !this.isNextSourceFeatureNull();
        }
        if (this.featureCounter >= this.requestMaxFeatures) {
            return false;
        }
        if (this.isSourceFeatureIteratorNull()) {
            return false;
        }
        boolean exists = this.unprocessedFeatureExists();
        if (!exists) {
            LOGGER.finest("no more features, produced " + this.featureCounter);
            this.close();
        }
        this.setHasNextCalled(true);
        return exists;
    }

    @Override
    protected Feature computeNext() throws IOException {
        Feature f = this.populateFeatureData();
        super.cleanEmptyElements(f);
        return f;
    }
}

