/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.expression.FeaturePropertyAccessorFactory;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.FeatureChainedAttributeVisitor;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.xml.sax.helpers.NamespaceSupport;

public class ComplexFilterSplitter
extends PostPreProcessFilterSplittingVisitor {
    private static final Logger LOGGER = Logging.getLogger(ComplexFilterSplitter.class);
    List<FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor> nestedAttributes = new ArrayList<FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor>();
    private FeatureTypeMapping mappings;

    public ComplexFilterSplitter(FilterCapabilities fcs, FeatureTypeMapping mappings) {
        super(fcs, null, null);
        this.mappings = mappings;
    }

    public Object visit(Id filter, Object notUsed) {
        CapabilitiesExpressionVisitor visitor = new CapabilitiesExpressionVisitor();
        this.mappings.getFeatureIdExpression().accept((ExpressionVisitor)visitor, null);
        if (visitor.isCapable()) {
            super.visit(filter, notUsed);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    public Object visit(Function expression, Object notUsed) {
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        Object data = super.visit(expression, notUsed);
        if (!this.nestedAttributes.isEmpty() && this.preStack.size() == i + 1) {
            Object o = this.preStack.pop();
            this.postStack.push(o);
        }
        return data;
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        Object ret = super.visit(filter, data);
        if (!this.nestedAttributes.isEmpty() && this.preStack.size() == i + 1) {
            Object o = this.preStack.pop();
            this.postStack.push(o);
        }
        return ret;
    }

    protected void visitMathExpression(BinaryExpression expression) {
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        super.visitMathExpression(expression);
        if (!this.nestedAttributes.isEmpty() && this.preStack.size() == i + 1) {
            Object o = this.preStack.pop();
            this.postStack.push(o);
        }
    }

    protected void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        super.visitBinarySpatialOperator(filter);
        if (this.preStack.size() == i + 1) {
            if (this.nestedAttributes.size() == 1) {
                this.nestedAttributeSanityCheck((Filter)filter);
            } else if (this.nestedAttributes.size() > 1) {
                Object o = this.preStack.pop();
                this.postStack.push(o);
            }
        }
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        super.visitBinaryComparisonOperator(filter);
        if (this.preStack.size() == i + 1) {
            if (this.nestedAttributes.size() == 1) {
                this.nestedAttributeSanityCheck((Filter)filter);
            } else if (this.nestedAttributes.size() > 1) {
                Object o = this.preStack.pop();
                this.postStack.push(o);
            }
        }
    }

    public Object visit(BBOX filter, Object notUsed) {
        PropertyName bboxProperty;
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        if (filter.getExpression1() instanceof PropertyName && !(bboxProperty = (PropertyName)filter.getExpression1()).getPropertyName().isEmpty()) {
            Object ret = this.visit(bboxProperty, notUsed);
            if (this.preStack.size() == i + 1) {
                this.preStack.pop();
            }
            if (this.nestedAttributes.size() == 1) {
                this.nestedAttributeSanityCheck((Filter)filter);
            } else if (this.nestedAttributes.size() > 1) {
                this.postStack.push(filter);
                return ret;
            }
        }
        return super.visit(filter, notUsed);
    }

    public Object visit(PropertyIsBetween filter, Object extradata) {
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        Object ret = super.visit(filter, extradata);
        if (this.preStack.size() == i + 1) {
            if (this.nestedAttributes.size() == 1) {
                this.nestedAttributeSanityCheck((Filter)filter);
            } else if (this.nestedAttributes.size() > 1) {
                Object o = this.preStack.pop();
                this.postStack.push(o);
            }
        }
        return ret;
    }

    public Object visit(PropertyIsLike filter, Object notUsed) {
        this.nestedAttributes.clear();
        int i = this.preStack.size();
        Object ret = super.visit(filter, notUsed);
        if (this.preStack.size() == i + 1) {
            if (this.nestedAttributes.size() == 1) {
                this.nestedAttributeSanityCheck((Filter)filter);
            } else if (this.nestedAttributes.size() > 1) {
                Object o = this.preStack.pop();
                this.postStack.push(o);
            }
        }
        return ret;
    }

    public Object visit(PropertyName expression, Object notUsed) {
        XPathUtil.StepList exprSteps;
        if ("__DEFAULT_GEOMETRY__".equals(expression.getPropertyName())) {
            String defGeomPath = this.mappings.getDefaultGeometryXPath();
            FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware(this.mappings.getNamespaces());
            expression = ff.property(defGeomPath);
        }
        if ((exprSteps = XPath.steps((AttributeDescriptor)this.mappings.getTargetFeature(), (String)expression.getPropertyName(), (NamespaceSupport)this.mappings.getNamespaces())).containsPredicate()) {
            this.postStack.push(expression);
            return null;
        }
        List<Expression> matchingMappings = this.mappings.findMappingsFor(exprSteps, false);
        if (AppSchemaDataAccessConfigurator.shouldEncodeNestedFilters()) {
            FeatureChainedAttributeVisitor nestedAttrExtractor = new FeatureChainedAttributeVisitor(this.mappings);
            nestedAttrExtractor.visit(expression, null);
            FeatureChainedAttributeVisitor existsAttrExtractor = this.existsExtractorVisitor();
            existsAttrExtractor.visit(expression, null);
            List<FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor> fcAttrs = nestedAttrExtractor.getFeatureChainedAttributes();
            this.checkAttributeFound(expression, exprSteps, nestedAttrExtractor, existsAttrExtractor, fcAttrs);
            if (fcAttrs.size() == 1 || !fcAttrs.isEmpty() && this.validateNoClientProperties(fcAttrs)) {
                FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor nestedAttrDescr = fcAttrs.get(0);
                if (nestedAttrDescr.chainSize() > 1 && nestedAttrDescr.isJoiningEnabled()) {
                    FeatureTypeMapping featureMapping = nestedAttrDescr.getFeatureTypeOwningAttribute();
                    this.nestedAttributes.add(nestedAttrDescr);
                    List<Expression> nestedMappings = featureMapping.findMappingsFor(nestedAttrDescr.getAttributePath(), false);
                    Iterator<Expression> it = matchingMappings.iterator();
                    while (it.hasNext()) {
                        if (it.next() != null) continue;
                        it.remove();
                    }
                    matchingMappings.addAll(nestedMappings);
                    for (int i = nestedAttrDescr.chainSize() - 2; i > 0; --i) {
                        FeatureChainedAttributeVisitor.FeatureChainLink mappingStep = nestedAttrDescr.getLink(i);
                        if (!mappingStep.hasNestedFeature()) continue;
                        FeatureChainedAttributeVisitor.FeatureChainLink parentStep = nestedAttrDescr.getLink(i);
                        NestedAttributeMapping nestedAttr = parentStep.getNestedFeatureAttribute();
                        FeatureTypeMapping nestedFeature = null;
                        try {
                            nestedFeature = nestedAttr.getFeatureTypeMapping(null);
                        }
                        catch (IOException e) {
                            LOGGER.warning("Exception occurred processing nested filter, encodingwill be disabled: " + e.getMessage());
                            this.postStack.push(expression);
                            return null;
                        }
                        Expression nestedExpr = nestedAttr.getMapping(nestedFeature).getSourceExpression();
                        matchingMappings.add(nestedExpr);
                    }
                }
            } else {
                this.postStack.push(expression);
                return null;
            }
        }
        if (matchingMappings.isEmpty()) {
            AttributeMapping candidate = this.mappings.getAttributeMapping(exprSteps);
            if (candidate != null && candidate.isMultiValued() && candidate.getMultipleValue() != null) {
                return super.visit(expression, notUsed);
            }
            this.postStack.push(expression);
            return null;
        }
        for (Expression expr : matchingMappings) {
            if (expr == null) {
                this.postStack.push(expression);
                return null;
            }
            CapabilitiesExpressionVisitor visitor = new CapabilitiesExpressionVisitor();
            expr.accept((ExpressionVisitor)visitor, null);
            if (visitor.isCapable()) continue;
            this.postStack.push(expression);
            return null;
        }
        return super.visit(expression, notUsed);
    }

    private boolean validateNoClientProperties(List<FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor> fcAttrs) {
        for (FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor ad : fcAttrs) {
            if (ad.getFeatureChain() == null) continue;
            for (FeatureChainedAttributeVisitor.FeatureChainLink clink : ad.getFeatureChain()) {
                if (clink.getNestedFeatureAttribute() == null || clink.getNestedFeatureAttribute().getClientProperties() == null || clink.getNestedFeatureAttribute().getClientProperties().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    protected void checkAttributeFound(PropertyName expression, XPathUtil.StepList exprSteps, FeatureChainedAttributeVisitor nestedAttrExtractor, FeatureChainedAttributeVisitor existsAttrExtractor, List<FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor> fcAttrs) {
        if (fcAttrs.isEmpty() && !nestedAttrExtractor.conditionalMappingWasFound() && !this.isXlinkHRef(exprSteps) && !existsAttrExtractor.isUnboundedNestedElementFound() && existsAttrExtractor.getFeatureChainedAttributes().isEmpty()) {
            throw new IllegalArgumentException(String.format("Attribute \"%s\" not found in type \"%s\"", expression, this.mappings.getTargetFeature().getName().toString()));
        }
    }

    protected boolean isXlinkHRef(XPathUtil.StepList exprSteps) {
        return FeatureChainedAttributeVisitor.isXlinkHref(exprSteps);
    }

    private FeatureChainedAttributeVisitor existsExtractorVisitor() {
        return new FeatureChainedAttributeVisitor(this.mappings){

            @Override
            protected boolean startsWith(XPathUtil.StepList one, XPathUtil.StepList other) {
                if (other.size() > one.size()) {
                    return false;
                }
                boolean result = true;
                for (int i = 0; i < other.size(); ++i) {
                    XPathUtil.Step thisStep = (XPathUtil.Step)one.get(i);
                    XPathUtil.Step otherStep = (XPathUtil.Step)other.get(i);
                    result = thisStep.isIndexed() && otherStep.isIndexed() ? result && thisStep.equals((Object)otherStep) : result && thisStep.equalsIgnoreIndex(otherStep);
                }
                return result;
            }
        };
    }

    private void nestedAttributeSanityCheck(Filter filter) {
        if (this.nestedAttributes != null) {
            for (FeatureChainedAttributeVisitor.FeatureChainedAttributeDescriptor descr : this.nestedAttributes) {
                FeatureTypeMapping ownerType = descr.getFeatureTypeOwningAttribute();
                XPathUtil.StepList attrPath = descr.getAttributePath();
                XPathUtil.StepList xpathSteps = attrPath.clone();
                if (Types.isSimpleContentType((PropertyType)ownerType.getTargetFeature().getType())) {
                    String ownerTypeName = Types.toPrefixedName((Name)ownerType.getTargetFeature().getName(), (NamespaceSupport)ownerType.getNamespaces());
                    boolean chainingSimpleType = ownerTypeName.equals(descr.getAttributePath().toString());
                    FeatureChainedAttributeVisitor.FeatureChainLink lastLink = descr.getLastLink();
                    if (chainingSimpleType && lastLink.previous() != null) {
                        ownerType = lastLink.previous().getFeatureTypeMapping();
                        XPathUtil.StepList prevXPathSteps = lastLink.previous().getNestedFeatureAttribute().getTargetXPath();
                        XPathUtil.Step prevLastStep = (XPathUtil.Step)prevXPathSteps.get(prevXPathSteps.size() - 1);
                        if (!prevLastStep.equalsIgnoreIndex((XPathUtil.Step)attrPath.get(0))) {
                            xpathSteps = prevXPathSteps.clone();
                            xpathSteps.add((Object)((XPathUtil.Step)attrPath.get(0)));
                        }
                    } else {
                        LOGGER.warning(String.format("Cound not run sanity check for nested attribute \"%s\" of type \"%s\"", descr.getAttributePath(), ownerType.getTargetFeature().getName()));
                    }
                }
                if (this.isXlinkHRef(xpathSteps = this.removeIndexesAndPredicates(xpathSteps)) || FeatureChainedAttributeVisitor.isFid(xpathSteps)) {
                    xpathSteps.remove(xpathSteps.size() - 1);
                }
                if (xpathSteps.isEmpty()) continue;
                Class<?> expectedType = this.determineExpectedType(filter, xpathSteps);
                this.checkPropetyExistenceAndType(ownerType, xpathSteps.toString(), expectedType);
            }
        }
    }

    private XPathUtil.StepList removeIndexesAndPredicates(XPathUtil.StepList steps) {
        XPathUtil.StepList newSteps = steps.clone();
        newSteps.clear();
        for (XPathUtil.Step step : steps) {
            newSteps.add((Object)new XPathUtil.Step(step.getName(), step.isXmlAttribute(), null));
        }
        return newSteps;
    }

    private Class<?> determineExpectedType(Filter filter, XPathUtil.StepList xpath) {
        Class<AttributeDescriptor> expectedType = AttributeDescriptor.class;
        if (filter instanceof BinarySpatialOperator) {
            expectedType = GeometryDescriptor.class;
        } else if (xpath.size() > 0) {
            boolean isXmlAttr = ((XPathUtil.Step)xpath.get(xpath.size() - 1)).isXmlAttribute();
            expectedType = isXmlAttr ? Name.class : AttributeDescriptor.class;
        }
        return expectedType;
    }

    private void checkPropetyExistenceAndType(FeatureTypeMapping mapping, String xpath, Class<?> expectedType) {
        FeatureType featureType = (FeatureType)mapping.getTargetFeature().getType();
        FeaturePropertyAccessorFactory accessorFactory = new FeaturePropertyAccessorFactory();
        Hints hints = new Hints((RenderingHints.Key)PropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)mapping.getNamespaces());
        PropertyAccessor accessor = accessorFactory.createPropertyAccessor(featureType.getClass(), xpath, Object.class, hints);
        if (accessor != null) {
            Object descr = null;
            try {
                descr = accessor.get((Object)featureType, xpath, Object.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Attribute \"%s\" not found in type \"%s\"", xpath, this.mappings.getTargetFeature().getName().toString()), e);
            }
            if (!expectedType.isAssignableFrom(descr.getClass())) {
                throw new IllegalArgumentException(String.format("Attribute descriptor for \"%s\" if of type \"%s\", but it should be of type \"%s\"", xpath, descr.getClass().getName(), expectedType.getName()));
            }
        }
    }

    public class CapabilitiesExpressionVisitor
    implements ExpressionVisitor {
        protected boolean capable = true;

        public boolean isCapable() {
            return this.capable;
        }

        public Object visit(NilExpression expr, Object extraData) {
            return null;
        }

        public Object visit(Add expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Subtract expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Divide expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Multiply expr, Object extraData) {
            this.visitMathExpression((BinaryExpression)expr);
            return null;
        }

        public Object visit(Function expr, Object extraData) {
            for (int i = 0; i < expr.getParameters().size(); ++i) {
                ((Expression)expr.getParameters().get(i)).accept((ExpressionVisitor)this, null);
            }
            this.capable = this.capable && ComplexFilterSplitter.this.fcs.supports(expr.getClass());
            return null;
        }

        public Object visit(Literal expr, Object extraData) {
            return null;
        }

        public Object visit(PropertyName expr, Object extraData) {
            return null;
        }

        private void visitMathExpression(BinaryExpression expression) {
            expression.getExpression1().accept((ExpressionVisitor)this, null);
            expression.getExpression2().accept((ExpressionVisitor)this, null);
            this.capable = this.capable && ComplexFilterSplitter.this.fcs.supports(expression.getClass());
        }
    }
}

