/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.joining.JoiningNestedAttributeMapping;
import org.geotools.filter.visitor.DefaultExpressionVisitor;
import org.geotools.util.logging.Logging;
import org.geotools.xlink.XLINK;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class FeatureChainedAttributeVisitor
extends DefaultExpressionVisitor {
    private static final Logger LOGGER = Logging.getLogger(FeatureChainedAttributeVisitor.class);
    private FeatureTypeMapping rootMapping;
    private List<FeatureChainedAttributeDescriptor> attributes;
    private boolean conditionalMappingFound;
    private boolean unboundedNestedElementFound = false;

    public FeatureChainedAttributeVisitor(FeatureTypeMapping root) {
        if (root == null) {
            throw new NullPointerException("root mapping is null");
        }
        this.attributes = new ArrayList<FeatureChainedAttributeDescriptor>();
        this.rootMapping = root;
        this.conditionalMappingFound = false;
    }

    public Object visit(PropertyName expression, Object data) {
        if (expression == null) {
            throw new NullPointerException("expression is null");
        }
        Feature feature = null;
        if (data != null && !(data instanceof Feature)) {
            feature = (Feature)data;
        }
        this.attributes = new ArrayList<FeatureChainedAttributeDescriptor>();
        try {
            this.walkXPath(expression.getPropertyName(), feature);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred splitting XPath expression into mapping steps", e);
        }
        return this.getFeatureChainedAttributes();
    }

    void walkXPath(String xpath, Feature feature) throws IOException {
        FeatureTypeMapping currentType = this.rootMapping;
        XPathUtil.StepList currentXPath = XPath.steps((AttributeDescriptor)this.rootMapping.getTargetFeature(), (String)xpath, (NamespaceSupport)this.rootMapping.getNamespaces());
        FeatureChainedAttributeDescriptor attrDescr = new FeatureChainedAttributeDescriptor();
        this.walkXPathRecursive(currentXPath, currentType, attrDescr, feature);
    }

    private void walkXPathRecursive(XPathUtil.StepList currentXPath, FeatureTypeMapping currentType, FeatureChainedAttributeDescriptor attrDescr, Feature feature) throws IOException {
        XPathUtil.StepList lastAttrPath;
        List<Expression> lastAttrExpressions;
        List<NestedAttributeMapping> currentAttributes = currentType.getNestedMappings();
        boolean searchIsOver = true;
        this.checkUnboundedElement(currentXPath, currentType);
        for (NestedAttributeMapping nestedAttr : currentAttributes) {
            XPathUtil.StepList targetXPath = nestedAttr.getTargetXPath();
            if (!this.startsWith(currentXPath, targetXPath)) continue;
            if (nestedAttr.isConditional() && feature == null) {
                this.logConditionalMappingFound(currentType, targetXPath);
                return;
            }
            FeatureTypeMapping nestedType = nestedAttr.getFeatureTypeMapping(feature);
            if (nestedType != null) {
                AttributeType nestedPropertyType = nestedType.getTargetFeature().getType();
                QName nestedTypeQName = this.getFeatureTypeQName(nestedType);
                XPathUtil.Step nestedTypeStep = new XPathUtil.Step(nestedTypeQName, 1);
                XPathUtil.StepList nestedTypeXPath = targetXPath.clone();
                nestedTypeXPath.add((Object)nestedTypeStep);
                boolean xpathContainsNestedType = this.startsWith(currentXPath, nestedTypeXPath);
                boolean hasSimpleContent = Types.isSimpleContentType((PropertyType)nestedPropertyType);
                if (!xpathContainsNestedType && !hasSimpleContent) continue;
                LOGGER.finer("Nested feature type found: " + String.valueOf(nestedTypeQName));
                FeatureChainedAttributeDescriptor copy = attrDescr.shallowCopy();
                copy.addLink(new FeatureChainLink(currentType, nestedAttr));
                FeatureTypeMapping newType = nestedType;
                XPathUtil.StepList newXPath = currentXPath.clone();
                int startIdx = xpathContainsNestedType ? nestedTypeXPath.size() : currentXPath.size();
                newXPath = newXPath.subList(startIdx, currentXPath.size());
                if (newXPath.isEmpty() && hasSimpleContent) {
                    newXPath.add((Object)nestedTypeStep);
                }
                this.walkXPathRecursive(newXPath, newType, copy, feature);
                searchIsOver = false;
                continue;
            }
            this.logNestedFeatureTypeNotFound(currentType, targetXPath);
        }
        if (searchIsOver && currentXPath != null && !currentXPath.isEmpty() && (lastAttrExpressions = currentType.findMappingsFor(lastAttrPath = currentXPath, false)) != null && !lastAttrExpressions.isEmpty()) {
            attrDescr.setAttributePath(lastAttrPath);
            if (FeatureChainedAttributeVisitor.isClientProperty(lastAttrPath) && FeatureChainedAttributeVisitor.isXlinkHref(lastAttrPath)) {
                XPathUtil.StepList parentAttrPath = lastAttrPath.subList(0, lastAttrPath.size() - 1);
                AttributeMapping parentAttr = currentType.getAttributeMapping(parentAttrPath);
                if (parentAttr != null && parentAttr instanceof NestedAttributeMapping) {
                    NestedAttributeMapping nestedAttr = (NestedAttributeMapping)parentAttr;
                    attrDescr.addLink(new FeatureChainLink(currentType, nestedAttr));
                    if (nestedAttr.isConditional() && feature == null) {
                        this.logConditionalMappingFound(currentType, nestedAttr.getTargetXPath());
                        return;
                    }
                    FeatureTypeMapping nestedType = nestedAttr.getFeatureTypeMapping(feature);
                    if (nestedType != null) {
                        FeatureChainLink lastLink = new FeatureChainLink(nestedType, true);
                        attrDescr.addLink(lastLink);
                        this.attributes.add(attrDescr);
                    } else {
                        this.logNestedFeatureTypeNotFound(currentType, nestedAttr.getTargetXPath());
                    }
                }
            } else {
                attrDescr.addLink(new FeatureChainLink(currentType));
                this.attributes.add(attrDescr);
            }
        }
    }

    private void checkUnboundedElement(XPathUtil.StepList currentXPath, FeatureTypeMapping currentType) {
        for (AttributeMapping attributeMapping : currentType.getAttributeMappings()) {
            for (Map.Entry<Name, Expression> entry : attributeMapping.getClientProperties().entrySet()) {
                if (!(entry.getKey() instanceof AppSchemaDataAccessConfigurator.ComplexNameImpl)) continue;
                AppSchemaDataAccessConfigurator.ComplexNameImpl complexQname = (AppSchemaDataAccessConfigurator.ComplexNameImpl)entry.getKey();
                XPathUtil.StepList unboundedElementStepList = attributeMapping.getTargetXPath().clone();
                XPathUtil.Step step = new XPathUtil.Step(new QName(complexQname.getNamespaceURI(), complexQname.getLocalPart(), currentType.getNamespaces().getPrefix(complexQname.getNamespaceURI())), unboundedElementStepList.size() + 1);
                unboundedElementStepList.add((Object)step);
                if (!currentXPath.equalsIgnoreIndex(unboundedElementStepList)) continue;
                this.unboundedNestedElementFound = true;
            }
        }
    }

    private void logConditionalMappingFound(FeatureTypeMapping containerType, XPathUtil.StepList xpath) {
        this.conditionalMappingFound = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            QName qname = this.getFeatureTypeQName(containerType);
            String prefixedName = qname.getPrefix() + ":" + qname.getLocalPart();
            LOGGER.fine("Conditional nested mapping found, but no feature to evaluate against was provided: nested feature type cannot be determined for container type \"" + prefixedName + "\" and target attribute \"" + String.valueOf(xpath));
        }
    }

    public boolean isUnboundedNestedElementFound() {
        return this.unboundedNestedElementFound;
    }

    private void logNestedFeatureTypeNotFound(FeatureTypeMapping containerType, XPathUtil.StepList xpath) {
        if (LOGGER.isLoggable(Level.FINE)) {
            QName qname = this.getFeatureTypeQName(containerType);
            String prefixedName = qname.getPrefix() + ":" + qname.getLocalPart();
            LOGGER.fine("Nested type could not be determined for container type \"" + prefixedName + "\" and target attribute \"" + String.valueOf(xpath));
        }
    }

    private QName getFeatureTypeQName(FeatureTypeMapping featureTypeMapping) {
        NamespaceSupport nsSupport = featureTypeMapping.getNamespaces();
        Name featureTypeName = featureTypeMapping.getTargetFeature().getName();
        String uri = featureTypeName.getNamespaceURI();
        String localPart = featureTypeName.getLocalPart();
        String prefix = nsSupport.getPrefix(uri);
        return new QName(uri, localPart, prefix);
    }

    static boolean isClientProperty(XPathUtil.StepList steps) {
        if (steps.isEmpty()) {
            return false;
        }
        return ((XPathUtil.Step)steps.get(steps.size() - 1)).isXmlAttribute();
    }

    static boolean isXlinkHref(XPathUtil.StepList steps) {
        if (steps.isEmpty()) {
            return false;
        }
        return ((XPathUtil.Step)steps.get(steps.size() - 1)).getName().equals(XLINK.HREF);
    }

    static boolean isFid(XPathUtil.StepList steps) {
        if (steps.isEmpty()) {
            return false;
        }
        return ((XPathUtil.Step)steps.get(steps.size() - 1)).toString().matches("@(\\w+:)?id");
    }

    public List<FeatureChainedAttributeDescriptor> getFeatureChainedAttributes() {
        return this.attributes;
    }

    public boolean conditionalMappingWasFound() {
        return this.conditionalMappingFound;
    }

    protected boolean startsWith(XPathUtil.StepList one, XPathUtil.StepList other) {
        return one.startsWith(other);
    }

    public static class FeatureChainLink {
        private FeatureTypeMapping featureTypeMapping;
        private NestedAttributeMapping nestedFeatureAttribute;
        private boolean chainingByReference;
        private String alias;
        private FeatureChainLink nextStep;
        private FeatureChainLink previousStep;

        private FeatureChainLink(FeatureTypeMapping featureType) {
            if (featureType == null) {
                throw new NullPointerException("featureType is null");
            }
            this.featureTypeMapping = featureType;
            this.nestedFeatureAttribute = null;
            this.chainingByReference = false;
            this.alias = featureType.getSource().getSchema().getName().getLocalPart();
            this.nextStep = null;
            this.previousStep = null;
        }

        private FeatureChainLink(FeatureTypeMapping featureType, NestedAttributeMapping nestedFeatureAttribute) {
            this(featureType);
            if (nestedFeatureAttribute == null) {
                throw new NullPointerException("nestedFeatureAttribute is null");
            }
            this.nestedFeatureAttribute = nestedFeatureAttribute;
        }

        private FeatureChainLink(FeatureTypeMapping featureType, boolean chainingByReference) {
            this(featureType);
            this.chainingByReference = chainingByReference;
        }

        public FeatureTypeMapping getFeatureTypeMapping() {
            return this.featureTypeMapping;
        }

        public NestedAttributeMapping getNestedFeatureAttribute() {
            return this.nestedFeatureAttribute;
        }

        public <T extends NestedAttributeMapping> T getNestedFeatureAttribute(Class<T> attributeMappingClass) {
            return (T)((NestedAttributeMapping)attributeMappingClass.cast(this.nestedFeatureAttribute));
        }

        public boolean isChainingByReference() {
            return this.chainingByReference;
        }

        public boolean isJoiningNestedMapping() {
            return this.nestedFeatureAttribute != null && this.nestedFeatureAttribute instanceof JoiningNestedAttributeMapping;
        }

        public boolean hasNestedFeature() {
            return this.nestedFeatureAttribute != null;
        }

        public String getAlias() {
            return this.alias;
        }

        private void setAlias(String alias) {
            this.alias = alias;
        }

        public FeatureChainLink next() {
            return this.nextStep;
        }

        public FeatureChainLink previous() {
            return this.previousStep;
        }
    }

    public static class FeatureChainedAttributeDescriptor {
        private List<FeatureChainLink> featureChain = new ArrayList<FeatureChainLink>();
        private XPathUtil.StepList attributePath;

        FeatureChainedAttributeDescriptor() {
        }

        public List<FeatureChainLink> getFeatureChain() {
            return new ArrayList<FeatureChainLink>(this.featureChain);
        }

        public void addLink(FeatureChainLink chainLink) {
            if (chainLink == null) {
                throw new NullPointerException("chainLink is null");
            }
            this.featureChain.add(chainLink);
            int size = this.featureChain.size();
            String alias = size == 1 ? "chain_root" : "chain_link_" + (size - 1);
            chainLink.setAlias(alias);
            if (size > 1) {
                FeatureChainLink previousStep = this.featureChain.get(size - 2);
                previousStep.nextStep = chainLink;
                chainLink.previousStep = previousStep;
            }
        }

        public FeatureChainLink getLink(int linkIdx) {
            if (linkIdx < 0) {
                throw new IllegalArgumentException("linkIdx must be > 0");
            }
            if (linkIdx >= this.featureChain.size()) {
                throw new IndexOutOfBoundsException("linkIdx " + linkIdx + " is not present");
            }
            return this.featureChain.get(linkIdx);
        }

        public FeatureChainLink getFirstLink() {
            if (this.featureChain.isEmpty()) {
                throw new IndexOutOfBoundsException("the list is empty");
            }
            return this.featureChain.get(0);
        }

        public FeatureChainLink getLastLink() {
            if (this.featureChain.isEmpty()) {
                throw new IndexOutOfBoundsException("the list is empty");
            }
            return this.featureChain.get(this.featureChain.size() - 1);
        }

        public boolean isJoiningEnabled() {
            boolean joiningEnabled = true;
            for (FeatureChainLink mappingStep : this.featureChain) {
                joiningEnabled = joiningEnabled && (!mappingStep.hasNestedFeature() || mappingStep.isJoiningNestedMapping());
            }
            return joiningEnabled;
        }

        void clearChain() {
            this.featureChain.clear();
        }

        public int chainSize() {
            return this.featureChain.size();
        }

        public XPathUtil.StepList getAttributePath() {
            return this.attributePath;
        }

        public void setAttributePath(XPathUtil.StepList attributePath) {
            this.attributePath = attributePath;
        }

        public FeatureTypeMapping getFeatureTypeOwningAttribute() {
            FeatureChainLink lastLink = this.getLastLink();
            FeatureTypeMapping featureMapping = lastLink.getFeatureTypeMapping();
            if (lastLink.isChainingByReference() && lastLink.previous() != null) {
                featureMapping = lastLink.previous().getFeatureTypeMapping();
            }
            return featureMapping;
        }

        public FeatureChainedAttributeDescriptor shallowCopy() {
            FeatureChainedAttributeDescriptor copy = new FeatureChainedAttributeDescriptor();
            copy.featureChain.addAll(this.featureChain);
            copy.attributePath = this.attributePath;
            return copy;
        }
    }
}

