/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;

public class IndexCombinedFilterTransformerVisitor
extends DuplicatingFilterVisitor {
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    private BinaryLogicOperator indexedParentLogicOperator;
    private List<Filter> indexedFilters;
    private Filter idInFilter;

    public IndexCombinedFilterTransformerVisitor(BinaryLogicOperator indexedParentLogicOperator, List<Filter> indexedFilters, Filter idInFilter) {
        this.indexedParentLogicOperator = indexedParentLogicOperator;
        this.indexedFilters = indexedFilters;
        this.idInFilter = idInFilter;
    }

    public Object visit(Or filter, Object extraData) {
        Or replace = this.process(filter);
        if (replace == null) {
            return super.visit(filter, extraData);
        }
        return replace;
    }

    public Object visit(And filter, Object extraData) {
        And replace = this.process(filter);
        if (replace == null) {
            return super.visit(filter, extraData);
        }
        return replace;
    }

    private <T extends BinaryLogicOperator> T process(T filter) {
        if (filter.equals(this.indexedParentLogicOperator)) {
            ArrayList<Filter> gfilters = new ArrayList<Filter>();
            gfilters.add(this.idInFilter);
            this.indexedParentLogicOperator.getChildren().stream().filter(f -> this.indexedFilters.stream().noneMatch(i -> i.equals(f))).forEach(f -> gfilters.add(this.duplicateFilter((Filter)f)));
            return this.createOperator(filter, gfilters);
        }
        return null;
    }

    private <T extends BinaryLogicOperator> T createOperator(T oldParent, List<Filter> children) {
        And result = null;
        if (oldParent instanceof And) {
            result = this.ff.and(children);
        } else if (oldParent instanceof Or) {
            result = this.ff.or(children);
        }
        return (T)result;
    }

    private Filter duplicateFilter(Filter filter) {
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor();
        Filter result = (Filter)filter.accept((FilterVisitor)visitor, (Object)this.ff);
        return result;
    }
}

