/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.appschema.util.IndexQueryUtils;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Or;

public class IndexedFilterDetectorVisitor
extends DefaultFilterVisitor {
    protected FeatureTypeMapping mapping;
    protected BinaryLogicOperator parentLogicOperator;
    protected List<Filter> indexedFilters = new ArrayList<Filter>();

    public IndexedFilterDetectorVisitor(FeatureTypeMapping mapping) {
        this.mapping = mapping;
    }

    public Object visit(Or filter, Object data) {
        if (this.parentLogicOperator != null) {
            return data;
        }
        this.processFilter((BinaryLogicOperator)filter);
        return super.visit(filter, data);
    }

    public Object visit(And filter, Object data) {
        if (this.parentLogicOperator != null) {
            return data;
        }
        this.processFilter((BinaryLogicOperator)filter);
        return super.visit(filter, data);
    }

    protected void processFilter(BinaryLogicOperator filter) {
        if (this.parentLogicOperator != null) {
            return;
        }
        boolean hasindexedFilter = filter.getChildren().stream().anyMatch(c -> this.isFullyIndexed((Filter)c));
        if (hasindexedFilter) {
            this.parentLogicOperator = filter;
            this.indexedFilters = filter.getChildren().stream().filter(c -> this.isFullyIndexed((Filter)c)).collect(Collectors.toList());
        }
    }

    protected boolean isFullyIndexed(Filter filter) {
        return IndexQueryUtils.checkAllPropertiesIndexed(IndexQueryUtils.getAttributesOnFilter(filter), this.mapping);
    }

    public BinaryLogicOperator getParentLogicOperator() {
        return this.parentLogicOperator;
    }

    public List<Filter> getIndexedFilters() {
        return this.indexedFilters;
    }
}

