/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.geotools.styling.css.util.UnboundSimplifyingFilterVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;

class CachedSimplifyingFilterVisitor
extends UnboundSimplifyingFilterVisitor {
    Map<Filter, Filter> cache = new WeakHashMap<Filter, Filter>();

    public CachedSimplifyingFilterVisitor(FeatureType ft) {
        this.setFeatureType(ft);
        this.setRangeSimplicationEnabled(true);
    }

    public Object visit(And filter, Object extraData) {
        Filter result = this.cache.get(filter);
        if (result == null) {
            result = (Filter)super.visit(filter, extraData);
            this.cache.put((Filter)filter, result);
        }
        return result;
    }

    public Object visit(Or filter, Object extraData) {
        Filter result = this.cache.get(filter);
        if (result == null) {
            result = (Filter)super.visit(filter, extraData);
            this.cache.put((Filter)filter, result);
        }
        return result;
    }

    public Object visit(Not filter, Object extraData) {
        Filter result = this.cache.get(filter);
        if (result == null) {
            result = (Filter)super.visit(filter, extraData);
            this.cache.put((Filter)filter, result);
        }
        return result;
    }

    protected List<Filter> extraAndSimplification(Object extraData, List<Filter> filters) {
        if (filters.size() > 1) {
            HashSet<Filter> topLevel = new HashSet<Filter>();
            for (Filter filter : filters) {
                if (filter instanceof Or) continue;
                topLevel.add(filter);
            }
            int i = 0;
            while (i < filters.size()) {
                Filter f = filters.get(i);
                boolean skip = false;
                if (f instanceof Or) {
                    Or or = (Or)f;
                    for (Filter child : or.getChildren()) {
                        if (!topLevel.contains(child)) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) {
                    filters.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (filters.size() > 1) {
            for (int i = 0; i < filters.size(); ++i) {
                Filter f = filters.get(i);
                if (!(f instanceof Or)) continue;
                Or or = (Or)f;
                Filter reduced = null;
                boolean twoOrMore = false;
                for (Filter child : or.getChildren()) {
                    ArrayList<Filter> newList = new ArrayList<Filter>(filters);
                    newList.remove(or);
                    newList.add(child);
                    And and = this.getFactory(extraData).and(newList);
                    Filter simplified = (Filter)and.accept((FilterVisitor)this, extraData);
                    if (simplified == Filter.EXCLUDE) continue;
                    if (simplified == Filter.INCLUDE) {
                        return Collections.singletonList(Filter.INCLUDE);
                    }
                    if (reduced == null) {
                        reduced = simplified;
                        continue;
                    }
                    if (simplified.equals(reduced)) continue;
                    twoOrMore = true;
                    break;
                }
                if (reduced == null) {
                    return Collections.singletonList(Filter.EXCLUDE);
                }
                if (twoOrMore) continue;
                filters.clear();
                if (!(reduced instanceof And)) {
                    return Collections.singletonList(reduced);
                }
                filters.addAll(((And)reduced).getChildren());
                filters = this.basicAndSimplification(filters);
                i = 0;
            }
        }
        return filters;
    }

    protected List<Filter> extraOrSimplification(Object extraData, List<Filter> filters) {
        if (filters.size() > 1) {
            HashSet<Filter> topLevel = new HashSet<Filter>();
            for (Filter filter : filters) {
                if (filter instanceof And) continue;
                topLevel.add(filter);
            }
            int i = 0;
            while (i < filters.size()) {
                Filter f = filters.get(i);
                boolean skip = false;
                if (f instanceof And) {
                    And and = (And)f;
                    for (Filter child : and.getChildren()) {
                        if (!topLevel.contains(child)) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) {
                    filters.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (filters.size() > 1) {
            for (int i = 0; i < filters.size(); ++i) {
                Filter f = filters.get(i);
                if (!(f instanceof And)) continue;
                And and = (And)f;
                Filter reduced = null;
                boolean twoOrMore = false;
                for (Filter child : and.getChildren()) {
                    ArrayList<Filter> newList = new ArrayList<Filter>(filters);
                    newList.remove(and);
                    newList.add(child);
                    Or or = this.getFactory(extraData).or(newList);
                    Filter simplified = (Filter)or.accept((FilterVisitor)this, extraData);
                    if (simplified == Filter.EXCLUDE) {
                        return Collections.singletonList(Filter.EXCLUDE);
                    }
                    if (simplified == Filter.INCLUDE) continue;
                    if (reduced == null) {
                        reduced = simplified;
                        continue;
                    }
                    if (simplified.equals(reduced)) continue;
                    twoOrMore = true;
                    break;
                }
                if (reduced == null) {
                    return Collections.singletonList(Filter.INCLUDE);
                }
                if (twoOrMore) continue;
                filters.clear();
                if (!(reduced instanceof Or)) {
                    return Collections.singletonList(reduced);
                }
                filters.addAll(((Or)reduced).getChildren());
                filters = this.basicOrSimplification(filters);
                i = 0;
            }
        }
        return filters;
    }
}

