/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.selector;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotools.styling.css.selector.And;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.SelectorVisitor;
import org.geotools.styling.css.selector.Specificity;

public class PseudoClass
extends Selector {
    public static final PseudoClass ROOT = new PseudoClass(null, -1){

        @Override
        public String toString() {
            return "ROOT";
        }
    };
    String className;
    int number = -1;

    public static Selector combineAnd(List<PseudoClass> selectors, Object ctx) {
        return new And(new ArrayList<Selector>(new LinkedHashSet<PseudoClass>(selectors)));
    }

    public String getClassName() {
        return this.className;
    }

    public int getNumber() {
        return this.number;
    }

    public static PseudoClass newPseudoClass(String className) {
        return PseudoClass.newPseudoClass(className, -1);
    }

    public static PseudoClass newPseudoClass(String className, int number) {
        return new PseudoClass(className, number);
    }

    private PseudoClass(String className, int number) {
        this.className = className;
        this.number = number;
    }

    public String toString() {
        return "PseudoClass [className=" + this.className + ", number=" + this.number + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + this.number;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PseudoClass other = (PseudoClass)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return this.number == other.number;
    }

    @Override
    public Specificity getSpecificity() {
        if (this.number < 0) {
            return Specificity.PSEUDO_1;
        }
        return Specificity.PSEUDO_2;
    }

    @Override
    public Object accept(SelectorVisitor visitor) {
        return visitor.visit(this);
    }

    public boolean contains(PseudoClass pc) {
        if (this.equals(ROOT)) {
            return true;
        }
        if (pc == null || ROOT.equals(pc)) {
            return false;
        }
        if ("symbol".equals(this.className) || this.className.equals(pc.className)) {
            return this.number < 0 || pc.number == this.number;
        }
        return false;
    }

    public static PseudoClass getMostSpecific(Set<PseudoClass> pseudoClasses) {
        PseudoClass mostSpecific = null;
        for (PseudoClass pc : pseudoClasses) {
            if (mostSpecific == null || mostSpecific.contains(pc)) {
                mostSpecific = pc;
                continue;
            }
            if (pc.contains(mostSpecific)) continue;
            return null;
        }
        return mostSpecific;
    }
}

