/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.selector;

import java.util.List;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.SelectorVisitor;
import org.geotools.styling.css.selector.Specificity;
import org.geotools.util.Range;

public class ScaleRange
extends Selector {
    public Range<Double> range;

    public static Selector combineAnd(List<ScaleRange> selectors, Object ctx) {
        if (selectors.size() == 1) {
            return selectors.get(0);
        }
        Range range = selectors.get((int)0).range;
        for (ScaleRange selector : selectors) {
            Range intersect = range.intersect(selector.range);
            if (!(range = intersect).isEmpty()) continue;
            return REJECT;
        }
        return new ScaleRange(range);
    }

    public ScaleRange(Range<Double> range) {
        this.range = range;
    }

    public ScaleRange(double min, boolean minIncluded, double max, boolean maxIncluded) {
        this.range = new Range(Double.class, (Comparable)Double.valueOf(min), minIncluded, (Comparable)Double.valueOf(max), maxIncluded);
    }

    @Override
    public Specificity getSpecificity() {
        return Specificity.PSEUDO_1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScaleRange other = (ScaleRange)obj;
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }

    public String toString() {
        return "ScaleRange " + String.valueOf(this.range);
    }

    @Override
    public Object accept(SelectorVisitor visitor) {
        return visitor.visit(this);
    }
}

