/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.flatgeobuf.FeatureCollectionConversions;
import org.geotools.data.flatgeobuf.FlatGeobufDataStore;
import org.geotools.data.flatgeobuf.FlatGeobufDirectoryDataStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentState;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;
import org.wololo.flatgeobuf.HeaderMeta;

public class FlatGeobufFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    final Iterator<SimpleFeature> it;
    final SimpleFeatureType featureType;
    final boolean isEmpty;
    InputStream inputStream;
    SimpleFeature nextFeature;

    FlatGeobufFeatureReader(ContentState state, Query q) throws IOException {
        this(state, q, null);
    }

    FlatGeobufFeatureReader(ContentState state, Query q, HeaderMeta headerMeta) throws IOException {
        URL url;
        File file;
        this.featureType = state.getFeatureType();
        ContentDataStore dataStore = state.getEntry().getDataStore();
        if (dataStore instanceof FlatGeobufDirectoryDataStore) {
            file = ((FlatGeobufDirectoryDataStore)dataStore).getDataStore(this.featureType.getTypeName()).getFile();
            url = ((FlatGeobufDirectoryDataStore)dataStore).getDataStore(this.featureType.getTypeName()).getURL();
        } else {
            file = ((FlatGeobufDataStore)dataStore).getFile();
            url = ((FlatGeobufDataStore)dataStore).getURL();
        }
        if (file != null && !file.exists()) {
            this.isEmpty = true;
            this.it = null;
            return;
        }
        this.isEmpty = false;
        this.inputStream = url.openStream();
        if (headerMeta == null) {
            headerMeta = HeaderMeta.read((InputStream)this.inputStream);
        } else {
            FlatGeobufFeatureReader.skipNBytes(this.inputStream, headerMeta.offset);
        }
        Filter filter = q.getFilter();
        ReferencedEnvelope bbox = new ReferencedEnvelope();
        Id id = null;
        if (q != null && filter != null) {
            bbox = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)bbox);
            if (filter instanceof Id) {
                id = (Id)filter;
            }
        }
        if (bbox == null || bbox.isNull() || Double.isInfinite(bbox.getWidth()) || Double.isInfinite(bbox.getHeight())) {
            bbox = null;
        }
        if (bbox != null) {
            this.it = FeatureCollectionConversions.deserialize(this.inputStream, headerMeta, this.featureType, (Envelope)bbox).iterator();
        } else if (id != null) {
            long featuresCount = headerMeta.featuresCount;
            long[] fids = id.getIdentifiers().stream().mapToLong(i -> FlatGeobufFeatureReader.extractFid(i)).filter(l -> l >= 0L && l < featuresCount).toArray();
            Arrays.sort(fids);
            this.it = FeatureCollectionConversions.deserialize(this.inputStream, headerMeta, this.featureType, fids).iterator();
        } else {
            this.it = FeatureCollectionConversions.deserialize(this.inputStream, headerMeta, this.featureType).iterator();
        }
    }

    private static long extractFid(Identifier i) {
        long fid = -1L;
        String idStr = i.getID().toString();
        int dotIndex = idStr.indexOf(".", 0);
        String idPart = idStr.substring(dotIndex + 1);
        try {
            fid = Long.parseLong(idPart);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return fid;
    }

    public static void skipNBytes(InputStream stream, long skip) throws IOException {
        long actual = 0L;
        for (long remaining = skip; actual < remaining; remaining -= stream.skip(remaining)) {
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature feature = null;
        if (this.nextFeature != null) {
            feature = this.nextFeature;
            this.nextFeature = null;
        } else {
            if (this.isEmpty) {
                throw new NoSuchElementException();
            }
            feature = this.it.next();
        }
        return feature;
    }

    public boolean hasNext() throws IOException {
        if (this.nextFeature != null) {
            return true;
        }
        if (this.isEmpty) {
            return false;
        }
        if (this.it.hasNext()) {
            this.nextFeature = this.it.next();
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

