/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core.color;

public class JlsTokenizer {
    private String data;
    private int dataLength;
    private String delimiters;
    private int position = 0;

    public JlsTokenizer(String str) {
        this(str, "\t\n\r\f");
    }

    public JlsTokenizer(String str, String delim) {
        this.data = str;
        this.delimiters = delim;
        this.dataLength = this.data.length();
    }

    public boolean hasMoreTokens() {
        return this.position <= this.dataLength;
    }

    public String nextToken() {
        char c;
        int delPos;
        for (delPos = this.position; delPos < this.dataLength && this.delimiters.indexOf(c = this.data.charAt(delPos)) == -1; ++delPos) {
        }
        String ret = this.data.substring(this.position, delPos);
        this.position = delPos + 1;
        return ret;
    }

    public String remainingToken() {
        return this.data.substring(this.position);
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int savedPosition = this.position;
        int count = 0;
        while (this.hasMoreTokens()) {
            this.nextToken();
            ++count;
        }
        this.position = savedPosition;
        return count;
    }
}

