/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.mbtiles.MBTilesDataStore;
import org.geotools.mbtiles.MBTilesFeatureSource;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesFileVectorTileTest;
import org.geotools.mbtiles.MBTilesRange;
import org.geotools.mbtiles.RectangleLong;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;

public class MBTilesFeatureSourceTest {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final PropertyName DEFAULT_GEOM = FF.property("");
    DataStore store;

    @After
    public void disposeStore() {
        if (this.store != null) {
            this.store.dispose();
        }
    }

    @Test
    public void readSinglePointDataTypes() throws IOException, ParseException {
        File file = URLs.urlToFile((URL)MBTilesFileVectorTileTest.class.getResource("datatypes.mbtiles"));
        this.store = new MBTilesDataStore(new MBTilesFile(file));
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)this.store.getFeatureSource("datatypes").getFeatures(Query.ALL));
        MatcherAssert.assertThat((Object)feature.getAttribute("bool_false"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)feature.getAttribute("bool_true"), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((Float)feature.getAttribute("float_value")).doubleValue(), (Matcher)Matchers.closeTo((double)1.25, (double)0.01));
        MatcherAssert.assertThat((Object)feature.getAttribute("int64_value"), (Matcher)Matchers.equalTo((Object)123456789012345L));
        MatcherAssert.assertThat((Object)feature.getAttribute("neg_int_value"), (Matcher)Matchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)feature.getAttribute("pos_int_value"), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)feature.getAttribute("string_value"), (Matcher)Matchers.equalTo((Object)"str"));
        Point expected = (Point)new WKTReader().read("POINT (215246.671651058 6281289.23636264)");
        Point actual = (Point)feature.getDefaultGeometry();
        Assert.assertTrue((boolean)actual.equalsExact((Geometry)expected, 0.01));
    }

    @Test
    public void readSinglePolygon() throws IOException, ParseException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        BBOX bbox = this.getMercatorBoxFilter(5635550.0, 5948635.0, -1565430.0, -1252345.0);
        ContentFeatureCollection fc = fs.getFeatures(new Query("water", (Filter)bbox));
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        MatcherAssert.assertThat((Object)feature.getAttribute("class"), (Matcher)Matchers.equalTo((Object)"ocean"));
        String wkt = "POLYGON ((5953527.258247068 -1570322.3088720688, 5630657.250815428 -1570322.3088720688, 5630657.250815428 -1247452.301440428, 5953527.258247068 -1247452.301440428, 5953527.258247068 -1570322.3088720688))";
        Polygon expected = (Polygon)new WKTReader().read(wkt);
        Polygon actual = (Polygon)feature.getDefaultGeometry();
        Assert.assertTrue((String)("Expected:\n" + String.valueOf(expected) + "\nBut got:\n" + String.valueOf(actual)), (boolean)actual.equalsExact((Geometry)expected, 0.1));
        Geometry clip = (Geometry)feature.getUserData().get(Hints.GEOMETRY_CLIP);
        String clipWkt = "POLYGON ((5635549.220624998 -1565430.3390625007, 5948635.288437498 -1565430.3390625007, 5948635.288437498 -1252344.2712500007, 5635549.220624998 -1252344.2712500007, 5635549.220624998 -1565430.3390625007))";
        Polygon expectedClip = (Polygon)new WKTReader().read(clipWkt);
        Assert.assertTrue((String)("Expected:\n" + String.valueOf(expectedClip) + "\nBut got:\n" + String.valueOf(clip)), (boolean)clip.equalsExact((Geometry)expectedClip, 0.1));
    }

    @Test
    public void queryAllBounds() throws IOException, SQLException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        List bounds = fs.getTileBoundsFor(new Query("water"), 7L);
        MatcherAssert.assertThat((Object)bounds, (Matcher)Matchers.contains((Object[])new RectangleLong[]{new RectangleLong(0L, 127L, 0L, 127L)}));
    }

    @Test
    public void queryWorldBounds() throws IOException, SQLException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        BBOX bbox = FF.bbox((Expression)DEFAULT_GEOM, (BoundingBox)MBTilesFile.WORLD_ENVELOPE);
        List bounds = fs.getTileBoundsFor(new Query("water", (Filter)bbox), 7L);
        MatcherAssert.assertThat((Object)bounds, (Matcher)Matchers.contains((Object[])new RectangleLong[]{new RectangleLong(0L, 127L, 0L, 127L)}));
    }

    @Test
    public void querySingleTile() throws IOException, SQLException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        BBOX bbox = this.getMercatorBoxFilter(5635550.0, 5948635.0, -1565430.0, -1252345.0);
        List bounds = fs.getTileBoundsFor(new Query("water", (Filter)bbox), 7L);
        MatcherAssert.assertThat((Object)bounds, (Matcher)Matchers.contains((Object[])new RectangleLong[]{new RectangleLong(82L, 82L, 59L, 59L)}));
    }

    @Test
    public void queryTwoTiles() throws IOException, SQLException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        BBOX bbox = this.getMercatorBoxFilter(5635550.0, 5948637.0, -1565430.0, -1252344.0);
        List bounds = fs.getTileBoundsFor(new Query("water", (Filter)bbox), 7L);
        MatcherAssert.assertThat((Object)bounds, (Matcher)Matchers.contains((Object[])new RectangleLong[]{new RectangleLong(82L, 83L, 59L, 60L)}));
    }

    private MBTilesFeatureSource getMadagascarSource(String typeName) throws IOException {
        if (this.store == null) {
            File file = URLs.urlToFile((URL)MBTilesFileVectorTileTest.class.getResource("madagascar.mbtiles"));
            this.store = new MBTilesDataStore(new MBTilesFile(file));
        }
        return (MBTilesFeatureSource)this.store.getFeatureSource(typeName);
    }

    @Test
    public void testGetLowerResolution() throws IOException, ParseException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        Query query = new Query("water", (Filter)FF.equal((Expression)FF.property("class"), (Expression)FF.literal((Object)"ocean"), true));
        query.setHints(new Hints((RenderingHints.Key)Hints.GEOMETRY_SIMPLIFICATION, (Object)78271.0));
        ContentFeatureCollection fc = fs.getFeatures(query);
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Geometry expected = new WKTReader().read(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("ocean_1_0_1.wkt"), (Charset)StandardCharsets.UTF_8));
        Geometry actual = (Geometry)feature.getDefaultGeometry();
        Assert.assertEquals((double)0.0, (double)expected.difference(actual).getArea(), (double)200000.0);
        Assert.assertEquals((double)0.0, (double)actual.difference(expected).getArea(), (double)200000.0);
    }

    @Test
    public void testGetLowerResolutionDistance() throws IOException, ParseException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        Query query = new Query("water", (Filter)FF.equal((Expression)FF.property("class"), (Expression)FF.literal((Object)"ocean"), true));
        query.setHints(new Hints((RenderingHints.Key)Hints.GEOMETRY_DISTANCE, (Object)78271.0));
        ContentFeatureCollection fc = fs.getFeatures(query);
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Geometry expected = new WKTReader().read(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("ocean_1_0_1.wkt"), (Charset)StandardCharsets.UTF_8));
        Geometry actual = (Geometry)feature.getDefaultGeometry();
        Assert.assertEquals((double)0.0, (double)expected.difference(actual).getArea(), (double)200000.0);
        Assert.assertEquals((double)0.0, (double)actual.difference(expected).getArea(), (double)200000.0);
    }

    @Test
    public void testReadMultipleLayers() throws IOException, ParseException {
        this.checkFirstFeature("water", "class", "ocean");
        this.checkFirstFeature("water", "class", "lake");
        this.checkFirstFeature("landcover", "class", "ice");
        this.checkFirstFeature("boundary", "admin_level", 2L);
        this.checkFirstFeature("place", "name", "Madagascar");
    }

    public void checkFirstFeature(String layerName, String propertyName, Object propertyValue) throws IOException {
        MBTilesFeatureSource fs = this.getMadagascarSource(layerName);
        Assert.assertEquals((Object)layerName, (Object)fs.getSchema().getTypeName());
        PropertyIsEqualTo filter = FF.equal((Expression)FF.property(propertyName), (Expression)FF.literal(propertyValue), true);
        Query query = new Query(layerName, (Filter)filter);
        query.setHints(new Hints((RenderingHints.Key)Hints.GEOMETRY_SIMPLIFICATION, (Object)78271.0));
        ContentFeatureCollection fc = fs.getFeatures(query);
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Assert.assertNotNull((String)("Could not find a feature with filter " + String.valueOf(filter)), (Object)feature);
        Assert.assertEquals((Object)feature.getFeatureType(), (Object)fc.getSchema());
        Assert.assertEquals((Object)propertyValue, (Object)feature.getAttribute(propertyName));
    }

    @Test
    public void testReadFeaturesNotFound() throws IOException {
        String layerName = "aerodrome_label";
        MBTilesFeatureSource fs = this.getMadagascarSource(layerName);
        ContentFeatureCollection fc = fs.getFeatures(new Query(layerName));
        Assert.assertNull((Object)DataUtilities.first((FeatureCollection)fc));
    }

    @Test
    public void testReadCache() throws Exception {
        HashSet<MBTilesRange> rangesRead = new HashSet<MBTilesRange>();
        this.store = this.getMadagascarRangeReadRecorder(rangesRead);
        SimpleFeatureSource water = this.store.getFeatureSource("water");
        BBOX bbox = this.getMercatorBoxFilter(5700000.0, 5900000.0, -1500000.0, -1300000.0);
        SimpleFeatureCollection fc = water.getFeatures(new Query("water", (Filter)bbox));
        Assert.assertEquals((long)1L, (long)this.countByVisit(fc));
        MatcherAssert.assertThat(rangesRead, (Matcher)Matchers.contains((Object[])new MBTilesRange[]{new MBTilesRange(7L, 82L, 82L, 59L, 59L)}));
        rangesRead.clear();
        Assert.assertEquals((long)1L, (long)this.countByVisit(fc));
        MatcherAssert.assertThat(rangesRead, (Matcher)Matchers.empty());
        rangesRead.clear();
        bbox = this.getMercatorBoxFilter(5500000.0, 5900000.0, -1500000.0, -1300000.0);
        fc = water.getFeatures(new Query("water", (Filter)bbox));
        Assert.assertEquals((long)2L, (long)this.countByVisit(fc));
        MatcherAssert.assertThat(rangesRead, (Matcher)Matchers.contains((Object[])new MBTilesRange[]{new MBTilesRange(7L, 81L, 81L, 59L, 59L)}));
        rangesRead.clear();
        fc = this.store.getFeatureSource("landcover").getFeatures(new Query("landcover", (Filter)bbox));
        Assert.assertEquals((long)2L, (long)this.countByVisit(fc));
        MatcherAssert.assertThat(rangesRead, (Matcher)Matchers.empty());
    }

    @Test
    public void testReadSeparateBounds() throws Exception {
        HashSet<MBTilesRange> rangesRead = new HashSet<MBTilesRange>();
        this.store = this.getMadagascarRangeReadRecorder(rangesRead);
        SimpleFeatureSource water = this.store.getFeatureSource("water");
        BBOX bbox1 = this.getMercatorBoxFilter(5700000.0, 5900000.0, -1500000.0, -1300000.0);
        BBOX bbox2 = this.getMercatorBoxFilter(5700000.0, 5900000.0, -2500000.0, -2100000.0);
        SimpleFeatureCollection fc = water.getFeatures(new Query("water", (Filter)FF.or((Filter)bbox1, (Filter)bbox2)));
        Assert.assertEquals((long)3L, (long)this.countByVisit(fc));
        MatcherAssert.assertThat(rangesRead, (Matcher)Matchers.contains((Object[])new MBTilesRange[]{new MBTilesRange(7L, 82L, 82L, 59L, 59L), new MBTilesRange(7L, 82L, 82L, 56L, 57L)}));
    }

    @Test
    public void testReadSeparateBoundsSmallGap() throws Exception {
        HashSet<MBTilesRange> rangesRead = new HashSet<MBTilesRange>();
        this.store = this.getMadagascarRangeReadRecorder(rangesRead);
        SimpleFeatureSource water = this.store.getFeatureSource("water");
        BBOX bbox1 = this.getMercatorBoxFilter(5700000.0, 5900000.0, -1500000.0, -1300000.0);
        BBOX bbox2 = this.getMercatorBoxFilter(5700000.0, 5900000.0, -1700000.0, -1550000.0);
        SimpleFeatureCollection fc = water.getFeatures(new Query("water", (Filter)FF.or((Filter)bbox1, (Filter)bbox2)));
        Assert.assertEquals((long)2L, (long)this.countByVisit(fc));
        MatcherAssert.assertThat(rangesRead, (Matcher)Matchers.contains((Object[])new MBTilesRange[]{new MBTilesRange(7L, 82L, 82L, 58L, 59L)}));
    }

    @Test
    public void testReadOutsideWorld() throws Exception {
        HashSet<MBTilesRange> rangesRead = new HashSet<MBTilesRange>();
        this.store = this.getMadagascarRangeReadRecorder(rangesRead);
        SimpleFeatureSource water = this.store.getFeatureSource("water");
        BBOX bbox = this.getMercatorBoxFilter(2.5E7, 2.6E7, -1500000.0, -1300000.0);
        SimpleFeatureCollection fc = water.getFeatures(new Query("water", (Filter)bbox));
        Assert.assertEquals((long)0L, (long)this.countByVisit(fc));
        MatcherAssert.assertThat(rangesRead, (Matcher)Matchers.empty());
    }

    @Test
    public void testGetBBOXQueryALL() throws Exception {
        File file = URLs.urlToFile((URL)MBTilesFileVectorTileTest.class.getResource("madagascar.mbtiles"));
        this.store = new MBTilesDataStore(new MBTilesFile(file));
        ReferencedEnvelope envelope = this.store.getFeatureSource("water").getBounds();
        Assert.assertNotNull((Object)envelope);
        Assert.assertEquals((Object)new ReferencedEnvelope(-2.0037508342789244E7, 2.0037508342789244E7, -2.0037471205137067E7, 2.003747120513706E7, CRS.decode((String)"EPSG:3857", (boolean)true)), (Object)envelope);
    }

    @Test
    public void testGetBBoxWithFilter() throws IOException {
        MBTilesFeatureSource fs = this.getMadagascarSource("water");
        Assert.assertEquals((Object)"water", (Object)fs.getSchema().getTypeName());
        PropertyIsEqualTo filter = FF.equal((Expression)FF.property("class"), (Expression)FF.literal((Object)"ocean"), true);
        Query query = new Query("water", (Filter)filter);
        ReferencedEnvelope envelope = fs.getBounds(query);
        Assert.assertNull((Object)envelope);
    }

    private BBOX getMercatorBoxFilter(double minX, double maxX, double minY, double maxY) {
        return FF.bbox((Expression)DEFAULT_GEOM, (BoundingBox)new ReferencedEnvelope(minX, maxX, minY, maxY, MBTilesFile.SPHERICAL_MERCATOR));
    }

    private MBTilesDataStore getMadagascarRangeReadRecorder(final Set<MBTilesRange> rangesRead) throws IOException {
        File file = URLs.urlToFile((URL)MBTilesFileVectorTileTest.class.getResource("madagascar.mbtiles"));
        MBTilesFile mbtiles = new MBTilesFile(file){

            public MBTilesFile.TileIterator tiles(long zoomLevel, long leftTile, long bottomTile, long rightTile, long topTile) throws SQLException {
                rangesRead.add(new MBTilesRange(zoomLevel, leftTile, rightTile, bottomTile, topTile));
                return super.tiles(zoomLevel, leftTile, bottomTile, rightTile, topTile);
            }
        };
        return new MBTilesDataStore(mbtiles);
    }

    private int countByVisit(SimpleFeatureCollection fc) throws IOException {
        AtomicInteger count = new AtomicInteger();
        fc.accepts(f -> count.incrementAndGet(), null);
        return count.get();
    }
}

