/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import org.geotools.mbtiles.MBTilesTileLocation;
import org.geotools.mbtiles.RectangleLong;
import org.junit.Assert;
import org.junit.Test;

public class RectangleLongTest {
    @Test
    public void expandToInclude() {
        RectangleLong rect = new RectangleLong();
        Assert.assertTrue((boolean)rect.isNull());
        rect.expandToInclude(new MBTilesTileLocation(0L, 10L, 20L));
        Assert.assertEquals((Object)new RectangleLong(10L, 10L, 20L, 20L), (Object)rect);
        Assert.assertFalse((boolean)rect.isNull());
    }

    @Test
    public void isNull() {
        Assert.assertTrue((boolean)new RectangleLong().isNull());
        Assert.assertFalse((boolean)new RectangleLong(1L, 2L, 3L, 4L).isNull());
    }

    @Test
    public void intersectionContains() {
        RectangleLong r1 = new RectangleLong(0L, 10L, 0L, 10L);
        RectangleLong r2 = new RectangleLong(5L, 7L, 5L, 7L);
        Assert.assertTrue((boolean)r1.intersects(r2));
        Assert.assertEquals((Object)r2, (Object)r1.intersection(r2));
        Assert.assertEquals((Object)r2, (Object)r2.intersection(r1));
    }

    @Test
    public void intersectionOverlap() {
        RectangleLong r1 = new RectangleLong(0L, 10L, 0L, 10L);
        RectangleLong r2 = new RectangleLong(5L, 15L, 5L, 15L);
        Assert.assertTrue((boolean)r1.intersects(r2));
        RectangleLong expected = new RectangleLong(5L, 10L, 5L, 10L);
        Assert.assertEquals((Object)expected, (Object)r1.intersection(r2));
        Assert.assertEquals((Object)expected, (Object)r2.intersection(r1));
    }

    @Test
    public void intersectionNone() {
        RectangleLong r1 = new RectangleLong(0L, 10L, 0L, 10L);
        RectangleLong r2 = new RectangleLong(15L, 20L, 15L, 20L);
        Assert.assertFalse((boolean)r1.intersects(r2));
        RectangleLong expected = new RectangleLong();
        Assert.assertEquals((Object)expected, (Object)r1.intersection(r2));
        Assert.assertEquals((Object)expected, (Object)r2.intersection(r1));
    }

    @Test
    public void testExpandToIncludeRect() {
        Assert.assertEquals((Object)new RectangleLong(0L, 10L, 0L, 10L), (Object)this.expand0_10_0_10(new RectangleLong(5L, 6L, 5L, 6L)));
        Assert.assertEquals((Object)new RectangleLong(-10L, 20L, -10L, 20L), (Object)this.expand0_10_0_10(new RectangleLong(-10L, 20L, -10L, 20L)));
        Assert.assertEquals((Object)new RectangleLong(0L, 15L, 0L, 10L), (Object)this.expand0_10_0_10(new RectangleLong(5L, 15L, 0L, 10L)));
        Assert.assertEquals((Object)new RectangleLong(-5L, 10L, 0L, 10L), (Object)this.expand0_10_0_10(new RectangleLong(-5L, 5L, 0L, 10L)));
        Assert.assertEquals((Object)new RectangleLong(0L, 10L, 0L, 15L), (Object)this.expand0_10_0_10(new RectangleLong(0L, 10L, 5L, 15L)));
        Assert.assertEquals((Object)new RectangleLong(0L, 10L, -5L, 10L), (Object)this.expand0_10_0_10(new RectangleLong(0L, 10L, -5L, 5L)));
        Assert.assertEquals((Object)new RectangleLong(0L, 30L, 0L, 10L), (Object)this.expand0_10_0_10(new RectangleLong(20L, 30L, 0L, 10L)));
    }

    public RectangleLong expand0_10_0_10(RectangleLong expand) {
        RectangleLong r1 = new RectangleLong(0L, 10L, 0L, 10L);
        r1.expandToInclude(expand);
        return r1;
    }
}

