/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.util.PartiallyOrderedSet;
import org.geotools.util.Utilities;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.RegistrableFactory;
import org.geotools.util.logging.Logging;

class CategoryRegistry {
    private final Map<Class<?>, InstanceRegistry<?>> categories;

    public CategoryRegistry(FactoryRegistry factoryRegistry, Iterable<Class<?>> categories) {
        Utilities.ensureArgumentNonNull("factoryRegistry", factoryRegistry);
        Utilities.ensureArgumentNonNull("categories", categories);
        this.categories = Utilities.stream(categories).collect(Collectors.collectingAndThen(Collectors.toMap(category -> category, category -> new InstanceRegistry(factoryRegistry, (Class<?>)category), (firstRegistry, secondRegistry) -> secondRegistry), Collections::unmodifiableMap));
    }

    public <T> void registerInstance(T instance) {
        Utilities.ensureArgumentNonNull("instance", instance);
        this.streamCategories().filter(category -> category.isAssignableFrom(instance.getClass())).map(category -> this.instanceRegistry((Class)category)).forEach(registry -> registry.register(instance));
    }

    public <T> boolean registerInstance(T instance, Class<T> category) {
        return this.instanceRegistry(category).register(instance);
    }

    public <T> void deregisterInstance(T instance) {
        Utilities.ensureArgumentNonNull("instance", instance);
        this.streamCategories().filter(category -> category.isAssignableFrom(instance.getClass())).map(category -> this.instanceRegistry((Class)category)).forEach(registry -> registry.deregister(instance));
    }

    public <T> boolean deregisterInstance(T instance, Class<T> category) {
        return this.instanceRegistry(category).deregister(instance);
    }

    public void deregisterInstances(Class<?> category) {
        this.instanceRegistry(category).clear();
    }

    public void deregisterInstances() {
        this.categories.values().forEach(InstanceRegistry::clear);
    }

    private <T> InstanceRegistry<T> instanceRegistry(Class<T> category) {
        Utilities.ensureArgumentNonNull("category", category);
        InstanceRegistry<?> registry = this.categories.get(category);
        if (registry == null) {
            throw new IllegalArgumentException("The category '" + String.valueOf(category) + "' is not registered");
        }
        return registry;
    }

    public Stream<Class<?>> streamCategories() {
        return this.categories.keySet().stream();
    }

    public <T> Stream<T> streamInstances(Class<T> category, boolean useOrder) {
        return this.instanceRegistry(category).stream(useOrder);
    }

    public <S> Optional<S> getInstanceOfType(Class<S> type) {
        Utilities.ensureArgumentNonNull("type", type);
        return this.streamCategories().filter(category -> category.isAssignableFrom(type)).map(this::instanceRegistry).flatMap(registry -> Utilities.stream(registry.getInstanceOfType(type))).findFirst();
    }

    public <T> boolean setOrder(Class<T> category, T firstInstance, T secondInstance) {
        Utilities.ensureArgumentNonNull("firstInstance", firstInstance);
        Utilities.ensureArgumentNonNull("secondInstance", secondInstance);
        return this.instanceRegistry(category).setOrder(firstInstance, secondInstance);
    }

    public <T> boolean clearOrder(Class<T> category, T firstInstance, T secondInstance) {
        Utilities.ensureArgumentNonNull("firstInstance", firstInstance);
        Utilities.ensureArgumentNonNull("secondInstance", secondInstance);
        return this.instanceRegistry(category).clearOrder(firstInstance, secondInstance);
    }

    public String toString() {
        return "CategoryRegistry [categories=" + String.valueOf(this.categories.keySet()) + "]";
    }

    private static class InstanceRegistry<T> {
        protected static final Logger LOGGER = Logging.getLogger(CategoryRegistry.class);
        private static Class<?> REGISTERABLE_SERVICE = null;
        private final FactoryRegistry factoryRegistry;
        private final Class<?> category;
        private final Map<Class<?>, T> instancesByType = new HashMap();
        private final PartiallyOrderedSet<T> orderedInstances = new PartiallyOrderedSet(false);

        private InstanceRegistry(FactoryRegistry factoryRegistry, Class<?> category) {
            this.factoryRegistry = factoryRegistry;
            this.category = category;
        }

        public boolean register(T instance) {
            Utilities.ensureArgumentNonNull("instance", instance);
            boolean deregistered = this.deregisterByType(instance);
            this.registerInternal(instance);
            this.notifyRegistered(instance);
            return !deregistered;
        }

        private void notifyRegistered(T instance) {
            if (instance instanceof RegistrableFactory) {
                ((RegistrableFactory)instance).onRegistration(this.factoryRegistry, this.category);
            }
            if (REGISTERABLE_SERVICE != null && REGISTERABLE_SERVICE.isInstance(instance)) {
                LOGGER.warning("Migrate instances from RegisterableService to RegistrableFactory: " + String.valueOf(instance));
            }
        }

        private void registerInternal(T instance) {
            this.instancesByType.put(instance.getClass(), instance);
            this.orderedInstances.add(instance);
        }

        public boolean deregister(T instance) {
            Utilities.ensureArgumentNonNull("instance", instance);
            if (this.instancesByType.containsKey(instance.getClass())) {
                this.deregisterByType(instance);
                return true;
            }
            return false;
        }

        private boolean deregisterByType(T instance) {
            boolean instanceWasRemoved;
            T removed = this.instancesByType.remove(instance.getClass());
            boolean bl = instanceWasRemoved = removed != null;
            if (instanceWasRemoved) {
                this.orderedInstances.remove(removed);
                this.notifyDeregistered(removed);
            }
            return instanceWasRemoved;
        }

        private void notifyDeregistered(T instance) {
            if (instance instanceof RegistrableFactory) {
                ((RegistrableFactory)instance).onDeregistration(this.factoryRegistry, this.category);
            }
        }

        public void clear() {
            Iterator<T> values = this.instancesByType.values().iterator();
            while (values.hasNext()) {
                T instance = values.next();
                values.remove();
                this.orderedInstances.remove(instance);
                this.notifyDeregistered(instance);
            }
        }

        public Stream<T> stream(boolean useOrder) {
            if (useOrder) {
                return this.orderedInstances.stream();
            }
            return this.instancesByType.values().stream();
        }

        public <S> Optional<S> getInstanceOfType(Class<S> type) {
            Utilities.ensureArgumentNonNull("type", type);
            T instance = this.instancesByType.get(type);
            return Optional.ofNullable(instance);
        }

        public boolean setOrder(T firstInstance, T secondInstance) {
            return this.instancesByType.containsKey(firstInstance.getClass()) && this.instancesByType.containsKey(secondInstance.getClass()) && this.orderedInstances.setOrder(firstInstance, secondInstance);
        }

        public boolean clearOrder(T firstInstance, T secondInstance) {
            Utilities.ensureArgumentNonNull("firstInstance", firstInstance);
            Utilities.ensureArgumentNonNull("secondInstance", secondInstance);
            return this.instancesByType.containsKey(firstInstance.getClass()) && this.instancesByType.containsKey(secondInstance.getClass()) && this.orderedInstances.clearOrder(firstInstance, secondInstance);
        }

        public String toString() {
            return "InstanceRegistry [category=" + this.category.getSimpleName() + "]";
        }

        static {
            try {
                REGISTERABLE_SERVICE = Class.forName("javax.imageio.spi.RegisterableService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

