/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.mongodb.MongoDataStore;
import org.geotools.data.mongodb.MongoSchemaInitParams;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;

public class MongoDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false);
    public static final DataAccessFactory.Param DATASTORE_URI = new DataAccessFactory.Param("data_store", String.class, "MongoDB URI", true, (Object)"mongodb://localhost/<database name>");
    public static final DataAccessFactory.Param SCHEMASTORE_URI = new DataAccessFactory.Param("schema_store", String.class, "Schema Store URI or URL", true, (Object)"file://<absolute path> or http://www.hosting.com/files.json");
    public static final DataAccessFactory.Param MAX_OBJECTS_FOR_SCHEMA = new DataAccessFactory.Param("max_objs_schema", Integer.class, "Max objects for schema generation", false, (Object)1);
    public static final DataAccessFactory.Param OBJECTS_IDS_FOR_SCHEMA = new DataAccessFactory.Param("objs_id_schema", String.class, "Objects IDs for schema generation (comma separated)", false, null);
    public static final DataAccessFactory.Param HTTP_USER = new DataAccessFactory.Param("http_user", String.class, "(Optional)If Schema file is hosted behind a password protected URL", false, null);
    public static final DataAccessFactory.Param HTTP_PASSWORD = new DataAccessFactory.Param("http_pass", String.class, "(Optional)If Schema file is hosted behind a password protected URL", false, null);

    public String getDisplayName() {
        return "MongoDB";
    }

    public String getDescription() {
        return "MongoDB database";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{NAMESPACE, DATASTORE_URI, SCHEMASTORE_URI, MAX_OBJECTS_FOR_SCHEMA, OBJECTS_IDS_FOR_SCHEMA, HTTP_USER, HTTP_PASSWORD};
    }

    public boolean isAvailable() {
        return true;
    }

    public MongoDataStore createDataStore(Map<String, ?> params) throws IOException {
        List<String> ids = this.getIds(params);
        Integer maxObjects = (Integer)MAX_OBJECTS_FOR_SCHEMA.lookUp(params);
        MongoSchemaInitParams schemaParams = MongoSchemaInitParams.builder().ids(ids.toArray(new String[0])).maxObjects(maxObjects != null ? maxObjects : 1).build();
        MongoDataStore dataStore = new MongoDataStore((String)DATASTORE_URI.lookUp(params), (String)SCHEMASTORE_URI.lookUp(params), true, schemaParams, this.getHTTPClient(params));
        String uri = (String)NAMESPACE.lookUp(params);
        if (uri != null) {
            dataStore.setNamespaceURI(uri);
        }
        return dataStore;
    }

    private List<String> getIds(Map<String, ?> params) throws IOException {
        String[] parts;
        ArrayList<String> ids = new ArrayList<String>();
        Object ofs = OBJECTS_IDS_FOR_SCHEMA.lookUp(params);
        if (ofs == null) {
            return ids;
        }
        if (!(ofs instanceof String)) {
            throw new IllegalArgumentException("Object Ids parameter should be String type.");
        }
        String idsStr = (String)ofs;
        for (String epart : parts = idsStr.split(",")) {
            String id = epart.trim();
            if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private HTTPClient getHTTPClient(Map<String, ?> params) throws IOException {
        String uri = (String)SCHEMASTORE_URI.lookUp(params);
        if (!uri.startsWith("http")) {
            return null;
        }
        HTTPClient simpleHttpClient = HTTPClientFinder.createClient();
        if (HTTP_USER.lookUp(params) == null || HTTP_PASSWORD.lookUp(params) == null) {
            return simpleHttpClient;
        }
        simpleHttpClient.setUser((String)HTTP_USER.lookUp(params));
        simpleHttpClient.setPassword((String)HTTP_PASSWORD.lookUp(params));
        return simpleHttpClient;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        throw new UnsupportedOperationException();
    }
}

