/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import org.apache.commons.lang3.StringUtils;
import org.geotools.data.mongodb.MongoCollectionMeta;
import org.geotools.data.mongodb.complex.JsonSelectAllFunction;
import org.geotools.data.mongodb.complex.JsonSelectFunction;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DWithin;

public class MongoFilterSplitter
extends PostPreProcessFilterSplittingVisitor {
    private MongoCollectionMeta mongoCollectionMeta;

    public MongoFilterSplitter(FilterCapabilities fcs, SimpleFeatureType parent, ClientTransactionAccessor transactionAccessor, MongoCollectionMeta mongoCollectionMeta) {
        super(fcs, parent, transactionAccessor);
        this.mongoCollectionMeta = mongoCollectionMeta;
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        Expression expression1 = filter.getExpression1();
        Expression expression2 = filter.getExpression2();
        if (expression1 instanceof JsonSelectFunction || expression1 instanceof JsonSelectAllFunction) {
            if (expression2 instanceof Literal) {
                this.preStack.push(filter);
            } else {
                this.postStack.push(filter);
            }
        } else if (expression2 instanceof JsonSelectFunction || expression2 instanceof JsonSelectAllFunction) {
            if (expression1 instanceof Literal) {
                this.preStack.push(filter);
            } else {
                this.postStack.push(filter);
            }
        } else {
            super.visitBinaryComparisonOperator(filter);
        }
    }

    protected void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        Expression expression2 = filter.getExpression2();
        if (filter instanceof DWithin && expression2 != null && expression2.evaluate(null, Geometry.class) instanceof Point) {
            if (this.mongoCollectionMeta != null && StringUtils.equalsAny((CharSequence)this.mongoCollectionMeta.getIndexes().get(filter.getExpression1().toString()), (CharSequence[])new CharSequence[]{"2dsphere", "2d"})) {
                super.visitBinarySpatialOperator(filter);
                return;
            }
            this.postStack.push(filter);
        } else {
            super.visitBinarySpatialOperator(filter);
        }
    }

    public Object visit(PropertyIsLike filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!(filter.getExpression() instanceof PropertyName)) {
            this.postStack.push(filter);
            return null;
        }
        int i = this.postStack.size();
        filter.getExpression().accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    public Object visit(PropertyIsNull filter, Object notUsed) {
        this.preStack.push(filter);
        return null;
    }
}

