/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb.complex;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.spi.CustomAttributeExpressionFactory;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.mongodb.MongoFeatureStore;
import org.geotools.data.mongodb.complex.CollectionLinkFunction;
import org.geotools.data.mongodb.complex.JsonSelectAllFunction;
import org.geotools.data.mongodb.complex.JsonSelectFunction;
import org.geotools.data.mongodb.complex.MongoNestedMapping;
import org.geotools.feature.type.Types;
import org.geotools.filter.ConstantExpression;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;

public class MongoNestedAttributeExpressionFactory
implements CustomAttributeExpressionFactory {
    public Expression createNestedAttributeExpression(FeatureTypeMapping mappings, XPathUtil.StepList xpath, NestedAttributeMapping nestedMapping) {
        return this.getSourceExpression(mappings, xpath, nestedMapping);
    }

    private Expression getSourceExpression(FeatureTypeMapping mappings, XPathUtil.StepList xpath, NestedAttributeMapping nestedMapping) {
        SearchResult result;
        if (!(mappings.getSource() instanceof MongoFeatureStore)) {
            return null;
        }
        if (!nestedMapping.getTargetXPath().equalsIgnoreIndex(xpath.subList(0, nestedMapping.getTargetXPath().size()))) {
            return Expression.NIL;
        }
        int steps = xpath.size();
        XPathUtil.StepList finalXpath = xpath.subList(nestedMapping.getTargetXPath().size(), steps);
        NestedAttributeMapping attributeMapping = nestedMapping;
        String jsonPath = this.addPath((AttributeMapping)attributeMapping, "");
        int end = finalXpath.size();
        for (int start = 0; end > start; start += result.index) {
            try {
                FeatureTypeMapping featureTypeMapping = attributeMapping.getFeatureTypeMapping(null);
                Name featureTypeName = featureTypeMapping.getTargetFeature().getName();
                QName name = ((XPathUtil.Step)finalXpath.get(start)).getName();
                if (Types.equals((Name)featureTypeName, (QName)name) && ++start >= end) break;
                result = this.search(finalXpath.subList(start, end), (AttributeMapping)attributeMapping);
                if (!result.found) break;
                attributeMapping = result.attributeMapping;
                jsonPath = this.addPath((AttributeMapping)attributeMapping, jsonPath);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error getting feature type mapping.");
            }
        }
        if (attributeMapping == null) {
            return Expression.NIL;
        }
        Expression sourceExpression = attributeMapping.getSourceExpression();
        if (sourceExpression instanceof JsonSelectFunction) {
            JsonSelectAllFunction jsonSelect = new JsonSelectAllFunction();
            jsonPath = this.addPath(jsonPath, ((JsonSelectFunction)sourceExpression).getJsonPath());
            List<ConstantExpression> parameters = Collections.singletonList(ConstantExpression.constant((Object)jsonPath));
            jsonSelect.setParameters(parameters);
            return jsonSelect;
        }
        return sourceExpression;
    }

    private String addPath(AttributeMapping attribute, String currentPath) {
        Expression sourceExpression;
        if (attribute instanceof MongoNestedMapping && (sourceExpression = attribute.getSourceExpression()) instanceof CollectionLinkFunction) {
            String collection = ((CollectionLinkFunction)sourceExpression).getPath();
            return this.addPath(currentPath, collection);
        }
        return currentPath;
    }

    private String addPath(String currentPath, String newPath) {
        return currentPath == null || currentPath.isEmpty() ? newPath : currentPath + "." + newPath;
    }

    private SearchResult search(XPathUtil.StepList xpath, AttributeMapping attributeMapping) throws Exception {
        for (int i = xpath.size(); i > 0; --i) {
            AttributeMapping foundAttributeMapping = this.match(attributeMapping, xpath.subList(0, i));
            if (foundAttributeMapping == null) continue;
            return new SearchResult(true, i, foundAttributeMapping);
        }
        return SearchResult.NOT_FOUND;
    }

    private AttributeMapping match(AttributeMapping attributeMapping, XPathUtil.StepList xpath) throws IOException {
        if (attributeMapping instanceof NestedAttributeMapping) {
            FeatureTypeMapping mappings = ((NestedAttributeMapping)attributeMapping).getFeatureTypeMapping(null);
            List attributesMappings = mappings.getAttributeMappings();
            for (AttributeMapping candidateAttributeMapping : attributesMappings) {
                if (!xpath.equalsIgnoreIndex(candidateAttributeMapping.getTargetXPath())) continue;
                return candidateAttributeMapping;
            }
        }
        return null;
    }

    private static final class SearchResult {
        static final SearchResult NOT_FOUND = new SearchResult(false, -1, null);
        final boolean found;
        final int index;
        final AttributeMapping attributeMapping;

        SearchResult(boolean found, int index, AttributeMapping attributeMapping) {
            this.found = found;
            this.index = index;
            this.attributeMapping = attributeMapping;
        }
    }
}

