/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import org.geotools.process.vector.GridTransform;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class BarnesSurfaceInterpolator {
    public static final float DEFAULT_NO_DATA_VALUE = -999.0f;
    private static final double INTERNAL_NO_DATA = Double.NaN;
    private int minObservationCount = 2;
    private double maxObservationDistance = 0.0;
    private double convergenceFactor = 0.3;
    private double lengthScale = 0.0;
    private int passCount = 1;
    private Coordinate[] inputObs;
    private float noDataValue = -999.0f;
    private boolean useObservationMask;
    private float[] estimatedObs;

    public BarnesSurfaceInterpolator(Coordinate[] observationData) {
        this.inputObs = observationData;
    }

    public void setPassCount(int passCount) {
        if (passCount < 1) {
            return;
        }
        this.passCount = passCount;
    }

    public void setLengthScale(double lengthScale) {
        this.lengthScale = lengthScale;
    }

    public void setConvergenceFactor(double convergenceFactor) {
        this.convergenceFactor = convergenceFactor;
    }

    public void setMaxObservationDistance(double maxObsDistance) {
        this.maxObservationDistance = maxObsDistance;
    }

    public void setMinObservationCount(int minObsCount) {
        this.minObservationCount = minObsCount;
    }

    public void setNoData(float noDataValue) {
        this.noDataValue = noDataValue;
    }

    public float[][] computeSurface(Envelope srcEnv, int xSize, int ySize) {
        this.useObservationMask = this.minObservationCount > 0 && this.maxObservationDistance > 0.0;
        float[][] grid = new float[xSize][ySize];
        GridTransform trans = new GridTransform(srcEnv, xSize, ySize);
        this.estimateGrid(grid, trans);
        if (this.passCount > 1) {
            this.estimatedObs = this.computeEstimatedObservations();
            this.refineGrid(grid, trans);
            for (int i = 3; i <= this.passCount; ++i) {
                this.refineEstimatedObservations(this.estimatedObs);
                this.refineGrid(grid, trans);
            }
        }
        return grid;
    }

    private float[] computeEstimatedObservations() {
        float[] estimate = new float[this.inputObs.length];
        for (int i = 0; i < this.inputObs.length; ++i) {
            Coordinate dp = this.inputObs[i];
            float est = (float)this.estimatedValue(dp.x, dp.y);
            estimate[i] = !Float.isNaN(est) ? est : (float)this.inputObs[i].getZ();
        }
        return estimate;
    }

    private float[] refineEstimatedObservations(float[] currEst) {
        float[] estimate = new float[this.inputObs.length];
        for (int i = 0; i < this.inputObs.length; ++i) {
            Coordinate dp = this.inputObs[i];
            float del = (float)this.refinedDelta(dp.x, dp.y, this.convergenceFactor);
            estimate[i] = !Float.isNaN(del) ? currEst[i] + del : (float)this.inputObs[i].getZ();
        }
        return estimate;
    }

    private void estimateGrid(float[][] grid, GridTransform trans) {
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[0].length; ++j) {
                float est;
                double x = trans.x(i);
                double y = trans.y(j);
                grid[i][j] = this.noDataValue;
                if (this.useObservationMask && !this.isSupportedGridPt(x, y) || Float.isNaN(est = (float)this.estimatedValue(x, y))) continue;
                grid[i][j] = est;
            }
        }
    }

    private void refineGrid(float[][] grid, GridTransform trans) {
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[0].length; ++j) {
                float del;
                double x = trans.x(i);
                double y = trans.y(j);
                if (grid[i][j] == this.noDataValue || Float.isNaN(del = (float)this.refinedDelta(x, y, this.convergenceFactor))) continue;
                grid[i][j] = grid[i][j] + del;
            }
        }
    }

    private boolean isSupportedGridPt(double x, double y) {
        int count = 0;
        for (Coordinate inputOb : this.inputObs) {
            double dist = this.distance(x, y, inputOb);
            if (!(dist <= this.maxObservationDistance)) continue;
            ++count;
        }
        return count >= this.minObservationCount;
    }

    private double distance(double x, double y, Coordinate p) {
        double dx = x - p.x;
        double dy = y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double estimatedValue(double x, double y) {
        Coordinate p = new Coordinate(x, y);
        double sumWgtVal = 0.0;
        double sumWgt = 0.0;
        int dataCount = 0;
        for (Coordinate inputOb : this.inputObs) {
            double wgt = this.weight(p, inputOb, this.lengthScale);
            if (Double.isNaN(wgt)) continue;
            sumWgtVal += wgt * inputOb.getZ();
            sumWgt += wgt;
            ++dataCount;
        }
        if (dataCount < this.minObservationCount) {
            return Double.NaN;
        }
        return sumWgtVal / sumWgt;
    }

    private double refinedDelta(double x, double y, double convergenceFactor) {
        Coordinate p = new Coordinate(x, y);
        double sumWgtVal = 0.0;
        double sumWgt = 0.0;
        int dataCount = 0;
        for (int i = 0; i < this.inputObs.length; ++i) {
            double wgt = this.weight(p, this.inputObs[i], this.lengthScale, convergenceFactor);
            if (Double.isNaN(wgt)) continue;
            sumWgtVal += wgt * (this.inputObs[i].getZ() - (double)this.estimatedObs[i]);
            sumWgt += wgt;
            ++dataCount;
        }
        if (dataCount < this.minObservationCount) {
            return Double.NaN;
        }
        return sumWgtVal / sumWgt;
    }

    private double weight(Coordinate dataPt, Coordinate gridPt, double lengthScale) {
        return this.weight(gridPt, dataPt, lengthScale, 1.0);
    }

    private double weight(Coordinate dataPt, Coordinate gridPt, double lengthScale, double convergenceFactor) {
        double dist = dataPt.distance(gridPt);
        return this.weight(dist, lengthScale, convergenceFactor);
    }

    private double weight(double dist, double lengthScale, double convergenceFactor) {
        double dr = dist / lengthScale;
        double w = Math.exp(-(dr * dr / convergenceFactor));
        return w;
    }
}

