/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tile.TileFactory;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.WebMercatorZoomLevel;
import org.geotools.tile.impl.ZoomLevel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class WebMercatorTileFactory
extends TileFactory {
    @Override
    public ZoomLevel getZoomLevel(int zoomLevel, TileService wmtSource) {
        return new WebMercatorZoomLevel(zoomLevel);
    }

    public static ReferencedEnvelope getExtentFromTileName(TileIdentifier tileName) {
        int z = tileName.getZ();
        ReferencedEnvelope extent = new ReferencedEnvelope(WebMercatorTileFactory.tile2lon(tileName.getX(), z), WebMercatorTileFactory.tile2lon(tileName.getX() + 1, z), WebMercatorTileFactory.tile2lat(tileName.getY(), z), WebMercatorTileFactory.tile2lat(tileName.getY() + 1, z), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return extent;
    }

    public static final double tile2lon(double x, int z) {
        return x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    public static final double tile2lat(double y, int z) {
        double n = Math.PI - Math.PI * 2 * y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }
}

