/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.util.ArrayList;
import java.util.List;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

class ColumnSet {
    public String tableName;
    public VPFFile table;
    public List<String> colNames = null;
    public boolean isGeometryTable = false;
    public VPFGeometryFactory geometryFactory;
    public Geometry geometry = null;
    public VPFColumn geometryColumn = null;
    public SimpleFeature currRow = null;

    ColumnSet() {
    }

    public void setTable(String name, VPFFile table) {
        this.tableName = name;
        this.table = table;
        if (table != null) {
            this.colNames = new ArrayList<String>();
            int colCount = this.table.getColumnCount();
            for (int icol = 0; icol < colCount; ++icol) {
                VPFColumn col = this.table.getColumn(icol);
                String colName = col.getName();
                this.colNames.add(colName);
            }
        }
    }

    public void setGeometry(boolean b, VPFGeometryFactory geometryFactory, VPFColumn geometryColumn) {
        this.isGeometryTable = b;
        this.geometryFactory = geometryFactory;
        this.geometryColumn = geometryColumn;
        if (geometryColumn != null) {
            this.colNames = new ArrayList<String>();
            String colName = geometryColumn.getName();
            this.colNames.add(colName);
        }
    }
}

