/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class WMTSHelper {
    public static String replaceToken(String baseUrl, String dimName, String dimValue) {
        String token = "{" + dimName.toLowerCase() + "}";
        int index = baseUrl.toLowerCase().indexOf(token);
        if (index != -1) {
            return baseUrl.substring(0, index) + (dimValue == null ? "" : dimValue) + baseUrl.substring(index + dimName.length() + 2);
        }
        return baseUrl;
    }

    public static String appendQueryString(String baseUrl, Map<String, String> params) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl cannot be null");
        }
        StringBuilder arguments = new StringBuilder();
        String separator = !baseUrl.contains("?") ? "?" : "&";
        String lowerBase = baseUrl.toLowerCase();
        try {
            for (String key : params.keySet()) {
                String val;
                if (lowerBase.contains(key.toLowerCase() + "=") || (val = params.get(key)) == null) continue;
                String valString = val.toString();
                arguments.append(separator).append(key).append("=").append(valString.startsWith("{") ? valString : URLEncoder.encode(valString, "UTF-8"));
                separator = "&";
            }
            return baseUrl + arguments.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Doesn't support UTF-8", e);
        }
    }

    public static String encodeParameter(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Doesn't support UTF-8", e);
        }
    }
}

