/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.geotools.util.URLs;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XSUnsignedBindingsTest {
    Parser p;

    @Before
    public void setUp() throws Exception {
        XSConfiguration xs = new XSConfiguration();
        this.p = new Parser((Configuration)xs);
    }

    @Test
    public void testParseUnsignedInt() throws Exception {
        Long l = (Long)this.p.parse((InputStream)new ByteArrayInputStream(this.doc("unsignedInt", "12").getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((long)12L, (long)l);
    }

    @Test
    public void testParseUnsignedByte() throws Exception {
        Short s = (Short)this.p.parse((InputStream)new ByteArrayInputStream(this.doc("unsignedByte", "12").getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((long)12L, (long)s.shortValue());
    }

    @Test
    public void testParseUnsignedShort() throws Exception {
        Integer i = (Integer)this.p.parse((InputStream)new ByteArrayInputStream(this.doc("unsignedShort", "12").getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((long)12L, (long)i.longValue());
    }

    @Test
    public void testParseUnsignedLong() throws Exception {
        BigDecimal l = (BigDecimal)this.p.parse((InputStream)new ByteArrayInputStream(this.doc("unsignedLong", "12").getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((long)12L, (long)l.longValue());
    }

    String doc(String elName, String elValue) throws IOException {
        File sampleXsd = File.createTempFile("sample", "xsd", new File("target"));
        this.copy(TestSchema.class.getResourceAsStream("sample.xsd"), sampleXsd);
        return String.format("<my:%s xmlns:my='http://localhost/xob/test' schemaLocation='http://localhost/xob/test %s'>%s</my:%s>", elName, URLs.fileToUrl((File)sampleXsd), elValue, elName);
    }

    void copy(InputStream in, File to) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(to);){
            byte[] buffer = new byte[1024];
            int n = 0;
            while ((n = in.read(buffer)) > 0) {
                fout.write(buffer, 0, n);
            }
            fout.flush();
        }
    }
}

