/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.httpproxy;

import it.geosolutions.httpproxy.HostChecker;
import it.geosolutions.httpproxy.HostNameChecker;
import it.geosolutions.httpproxy.HttpErrorException;
import it.geosolutions.httpproxy.MethodsChecker;
import it.geosolutions.httpproxy.MimeTypeChecker;
import it.geosolutions.httpproxy.ProxyCallback;
import it.geosolutions.httpproxy.ProxyConfig;
import it.geosolutions.httpproxy.ProxyInfo;
import it.geosolutions.httpproxy.RequestTypeChecker;
import it.geosolutions.httpproxy.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPProxy
extends HttpServlet {
    private static final long serialVersionUID = -4770692886388850680L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPProxy.class);
    private int maxFileUploadSize = 0x500000;
    private PoolingHttpClientConnectionManager connectionManager;
    HttpClientBuilder clientBuilder = HttpClientBuilder.create();
    private HttpClient httpClient;
    private ProxyConfig proxyConfig;
    private List<ProxyCallback> callbacks;
    private BasicCredentialsProvider credsProvider = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext context = this.getServletContext();
        String proxyPropPath = context.getInitParameter("proxyPropPath");
        this.proxyConfig = new ProxyConfig(this.getServletContext(), proxyPropPath);
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(6);
        this.connectionManager.setDefaultMaxPerRoute(6);
        this.httpClient = this.createHttpClient();
        this.callbacks = new ArrayList<ProxyCallback>();
        this.callbacks.add(new MimeTypeChecker(this.proxyConfig));
        this.callbacks.add(new HostNameChecker(this.proxyConfig));
        this.callbacks.add(new RequestTypeChecker(this.proxyConfig));
        this.callbacks.add(new MethodsChecker(this.proxyConfig));
        this.callbacks.add(new HostChecker(this.proxyConfig));
    }

    public HttpClient createHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        HttpHost httpHost = this.getHost("http.proxyHost", "http.proxyPort");
        LOGGER.debug("HTTP proxy host: " + httpHost);
        HttpHost httpsHost = this.getHost("https.proxyHost", "https.proxyPort");
        LOGGER.debug("HTTPS proxy host: " + httpsHost);
        HttpRoutePlanner routePlanner = this.getRoutePlanner(httpHost, httpsHost);
        this.clientBuilder.setRoutePlanner(routePlanner);
        this.clientBuilder.useSystemProperties();
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        LOGGER.info("HTTP Client created");
        return this.clientBuilder.build();
    }

    private HttpHost getHost(String proxyHostKey, String proxyPortKey) {
        HttpHost httpHost = null;
        String proxyHost = System.getProperty(proxyHostKey);
        if (proxyHost != null && !proxyHost.isEmpty()) {
            int proxyPort = 80;
            proxyPort = System.getProperty(proxyPortKey) != null ? Integer.parseInt(System.getProperty(proxyPortKey)) : proxyPort;
            httpHost = new HttpHost(proxyHost, proxyPort);
        }
        return httpHost;
    }

    private HttpRoutePlanner getRoutePlanner(final HttpHost httpHost, final HttpHost httpsHost) {
        return new HttpRoutePlanner(){

            public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) {
                LOGGER.info("HTTP proxy target host: " + target);
                if (HTTPProxy.this.isNonProxyHost(target.getHostName()).booleanValue()) {
                    LOGGER.info("Returning direct route");
                    return new HttpRoute(target);
                }
                LOGGER.info("Returning proxy route");
                return this.getProxyRoute(target);
            }

            private HttpRoute getProxyRoute(HttpHost target) {
                if (target.getSchemeName().equals("http")) {
                    LOGGER.debug("Setting http scheme");
                    if (httpHost == null) {
                        return new HttpRoute(target);
                    }
                    return new HttpRoute(target, null, httpHost, false);
                }
                LOGGER.debug("Setting https scheme");
                if (httpsHost == null) {
                    return new HttpRoute(target, null, true);
                }
                return new HttpRoute(target, null, httpsHost, true);
            }
        };
    }

    private Boolean isNonProxyHost(String host) {
        boolean isNonProxyHost = false;
        String nonProxyHostProp = System.getProperty("http.nonProxyHosts");
        if (nonProxyHostProp != null) {
            if (nonProxyHostProp.startsWith("\"")) {
                nonProxyHostProp = nonProxyHostProp.substring(1);
            }
            if (nonProxyHostProp.endsWith("\"")) {
                nonProxyHostProp = nonProxyHostProp.substring(0, nonProxyHostProp.length() - 1);
            }
            LOGGER.info("http.nonProxyHosts value: " + nonProxyHostProp);
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHostProp, "|");
            while (tokenizer.hasMoreTokens()) {
                String str = tokenizer.nextToken().trim();
                Pattern pattern = Pattern.compile(str = str.replace("*", "[\\w-]*"));
                Matcher matcher = pattern.matcher(host);
                if (!matcher.matches()) continue;
                LOGGER.info("Non proxy host matched for: " + str);
                isNonProxyHost = true;
                break;
            }
        }
        return isNonProxyHost;
    }

    void onInit(HttpServletRequest request, HttpServletResponse response, URL url) throws IOException {
        for (ProxyCallback callback : this.callbacks) {
            callback.onRequest(request, response, url);
        }
    }

    void onRemoteResponse(HttpRequestBase method) throws IOException {
        for (ProxyCallback callback : this.callbacks) {
            callback.onRemoteResponse(method);
        }
    }

    void onFinish() throws IOException {
        for (ProxyCallback callback : this.callbacks) {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            URL url = null;
            String user = null;
            String password = null;
            Set entrySet = httpServletRequest.getParameterMap().entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry anEntrySet;
                Map.Entry header = anEntrySet = iterator.next();
                String key = (String)header.getKey();
                String value = ((String[])header.getValue())[0];
                if ("user".equals(key)) {
                    user = value;
                    continue;
                }
                if ("password".equals(key)) {
                    password = value;
                    continue;
                }
                if (!"url".equals(key)) continue;
                url = Utils.buildURL(value);
            }
            if (url != null) {
                this.onInit(httpServletRequest, httpServletResponse, url);
                HttpGet getMethodProxyRequest = this.getGetMethod(url);
                this.setProxyRequestHeaders(url, httpServletRequest, (HttpRequestBase)getMethodProxyRequest);
                this.executeProxyRequest((HttpRequestBase)getMethodProxyRequest, httpServletRequest, httpServletResponse, user, password);
            }
        }
        catch (HttpErrorException ex) {
            httpServletResponse.sendError(ex.getCode(), ex.getMessage());
        }
        finally {
            this.onFinish();
        }
    }

    protected HttpGet getGetMethod(URL url) {
        return new HttpGet(url.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            URL url = null;
            String user = null;
            String password = null;
            Map<String, String> pars = this.splitQuery(httpServletRequest.getQueryString());
            for (String key : pars.keySet()) {
                String value = pars.get(key);
                if ("user".equals(key)) {
                    user = value;
                    continue;
                }
                if ("password".equals(key)) {
                    password = value;
                    continue;
                }
                if (!"url".equals(key)) continue;
                url = Utils.buildURL(value);
            }
            if (url != null) {
                this.onInit(httpServletRequest, httpServletResponse, url);
                HttpPost postMethodProxyRequest = this.getPostMethod(url);
                this.setProxyRequestHeaders(url, httpServletRequest, (HttpRequestBase)postMethodProxyRequest);
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
                    this.handleMultipart((HttpRequestBase)postMethodProxyRequest, httpServletRequest);
                } else {
                    this.handleStandard((HttpRequestBase)postMethodProxyRequest, httpServletRequest);
                }
                this.executeProxyRequest((HttpRequestBase)postMethodProxyRequest, httpServletRequest, httpServletResponse, user, password);
            }
        }
        catch (HttpErrorException ex) {
            httpServletResponse.sendError(ex.getCode(), ex.getMessage());
        }
        finally {
            this.onFinish();
        }
    }

    protected HttpPost getPostMethod(URL url) {
        return new HttpPost(url.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            URL url = null;
            String user = null;
            String password = null;
            Map<String, String> pars = this.splitQuery(httpServletRequest.getQueryString());
            for (String key : pars.keySet()) {
                String value = pars.get(key);
                if ("user".equals(key)) {
                    user = value;
                    continue;
                }
                if ("password".equals(key)) {
                    password = value;
                    continue;
                }
                if (!"url".equals(key)) continue;
                url = Utils.buildURL(value);
            }
            if (url != null) {
                this.onInit(httpServletRequest, httpServletResponse, url);
                HttpPut putMethodProxyRequest = new HttpPut(url.toExternalForm());
                this.setProxyRequestHeaders(url, httpServletRequest, (HttpRequestBase)putMethodProxyRequest);
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
                    this.handleMultipart((HttpRequestBase)putMethodProxyRequest, httpServletRequest);
                } else {
                    this.handleStandard((HttpRequestBase)putMethodProxyRequest, httpServletRequest);
                }
                this.executeProxyRequest((HttpRequestBase)putMethodProxyRequest, httpServletRequest, httpServletResponse, user, password);
            }
        }
        catch (HttpErrorException ex) {
            httpServletResponse.sendError(ex.getCode(), ex.getMessage());
        }
        finally {
            this.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            URL url = null;
            String user = null;
            String password = null;
            Map<String, String> pars = this.splitQuery(httpServletRequest.getQueryString());
            for (String key : pars.keySet()) {
                String value = pars.get(key);
                if ("user".equals(key)) {
                    user = value;
                    continue;
                }
                if ("password".equals(key)) {
                    password = value;
                    continue;
                }
                if (!"url".equals(key)) continue;
                url = Utils.buildURL(value);
            }
            if (url != null) {
                this.onInit(httpServletRequest, httpServletResponse, url);
                HttpDelete deleteMethodProxyRequest = new HttpDelete(url.toExternalForm());
                this.setProxyRequestHeaders(url, httpServletRequest, (HttpRequestBase)deleteMethodProxyRequest);
                this.executeProxyRequest((HttpRequestBase)deleteMethodProxyRequest, httpServletRequest, httpServletResponse, user, password);
            }
        }
        catch (HttpErrorException ex) {
            httpServletResponse.sendError(ex.getCode(), ex.getMessage());
        }
        finally {
            this.onFinish();
        }
    }

    private void handleMultipart(HttpRequestBase methodProxyRequest, HttpServletRequest httpServletRequest) throws ServletException {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        diskFileItemFactory.setSizeThreshold(this.getMaxFileUploadSize());
        diskFileItemFactory.setRepository(Utils.DEFAULT_FILE_UPLOAD_TEMP_DIRECTORY);
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        try {
            List listFileItems = servletFileUpload.parseRequest(httpServletRequest);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            for (FileItem fileItemCurrent : listFileItems) {
                if (fileItemCurrent.isFormField()) {
                    multipartEntityBuilder = multipartEntityBuilder.addTextBody(fileItemCurrent.getFieldName(), fileItemCurrent.getString());
                    continue;
                }
                multipartEntityBuilder = multipartEntityBuilder.addPart("file", (ContentBody)fileItemCurrent);
            }
            HttpEntity entity = multipartEntityBuilder.build();
            if (methodProxyRequest instanceof HttpPost) {
                ((HttpPost)methodProxyRequest).setEntity(entity);
            } else if (methodProxyRequest instanceof HttpPut) {
                ((HttpPut)methodProxyRequest).setEntity(entity);
            }
            methodProxyRequest.setHeader(entity.getContentType());
        }
        catch (FileUploadException fileUploadException) {
            throw new ServletException((Throwable)fileUploadException);
        }
    }

    private void handleStandard(HttpRequestBase methodProxyRequest, HttpServletRequest httpServletRequest) throws IOException {
        try {
            if (methodProxyRequest instanceof HttpPost) {
                ((HttpPost)methodProxyRequest).setEntity((HttpEntity)new InputStreamEntity((InputStream)httpServletRequest.getInputStream()));
            } else if (methodProxyRequest instanceof HttpPut) {
                ((HttpPut)methodProxyRequest).setEntity((HttpEntity)new InputStreamEntity((InputStream)httpServletRequest.getInputStream()));
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeProxyRequest(HttpRequestBase httpMethodProxyRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String user, String password) throws ServletException {
        if (user != null && password != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
            this.credsProvider = new BasicCredentialsProvider();
            this.credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider);
            this.httpClient = null;
            this.httpClient = this.createHttpClient();
        }
        InputStream inputStreamServerResponse = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpMethodProxyRequest);
            this.onRemoteResponse(httpMethodProxyRequest);
            if (this.getStatusCode(response) >= 300 && this.getStatusCode(response) < 304) {
                String stringStatusCode = Integer.toString(this.getStatusCode(response));
                String stringLocation = httpMethodProxyRequest.getFirstHeader("Location").getValue();
                if (stringLocation == null) {
                    throw new ServletException("Received status code: " + stringStatusCode + " but no " + "Location" + " header was found in the response");
                }
                String redirectURL = httpServletRequest.getRequestURL() + "?url=" + URLEncoder.encode(stringLocation, "UTF-8");
                httpServletResponse.sendRedirect(redirectURL);
                LOGGER.info("redirected to:" + redirectURL);
                return;
            }
            if (this.getStatusCode(response) == 304) {
                httpServletResponse.setIntHeader("Content-Length", 0);
                httpServletResponse.setStatus(304);
                return;
            }
            httpServletResponse.setStatus(this.getStatusCode(response));
            if (response.getAllHeaders() != null) {
                Header[] headerArrayResponse;
                for (Header header : headerArrayResponse = response.getAllHeaders()) {
                    if (header.getName().equalsIgnoreCase("accept-encoding") && header.getValue().toLowerCase().contains("gzip") || header.getName().equalsIgnoreCase("content-encoding") && header.getValue().toLowerCase().contains("gzip") || header.getName().equalsIgnoreCase("transfer-encoding")) continue;
                    httpServletResponse.setHeader(header.getName(), header.getValue());
                }
            }
            if ((inputStreamServerResponse = response.getEntity().getContent()) != null) {
                byte[] b = new byte[this.proxyConfig.getDefaultStreamByteSize()];
                int read = 0;
                ServletOutputStream out = httpServletResponse.getOutputStream();
                while ((read = inputStreamServerResponse.read(b)) > 0) {
                    out.write(b, 0, read);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing HTTP method", (Throwable)e);
        }
        finally {
            try {
                if (inputStreamServerResponse != null) {
                    inputStreamServerResponse.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error closing request input stream", (Throwable)e);
                throw new ServletException(e.getMessage());
            }
            httpMethodProxyRequest.releaseConnection();
        }
    }

    int getStatusCode(HttpResponse response) {
        if (response != null) {
            StatusLine statusLine = response.getStatusLine();
            return statusLine.getStatusCode();
        }
        return -1;
    }

    private ProxyInfo setProxyRequestHeaders(URL url, HttpServletRequest httpServletRequest, HttpRequestBase httpMethodProxyRequest) {
        String proxyHost = url.getHost();
        int proxyPort = url.getPort();
        String proxyPath = url.getPath();
        ProxyInfo proxyInfo = new ProxyInfo(proxyHost, proxyPath, proxyPort);
        Enumeration enumerationOfHeaderNames = httpServletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String stringHeaderName = (String)enumerationOfHeaderNames.nextElement();
            if (stringHeaderName.equalsIgnoreCase("Content-Length")) continue;
            Enumeration enumerationOfHeaderValues = httpServletRequest.getHeaders(stringHeaderName);
            while (enumerationOfHeaderValues.hasMoreElements()) {
                String stringHeaderValue = (String)enumerationOfHeaderValues.nextElement();
                if (stringHeaderName.equalsIgnoreCase("Host")) {
                    stringHeaderValue = Utils.getProxyHostAndPort(proxyInfo);
                }
                if (stringHeaderName.equalsIgnoreCase("accept-encoding") && stringHeaderValue.toLowerCase().contains("gzip") || stringHeaderName.equalsIgnoreCase("content-encoding") && stringHeaderValue.toLowerCase().contains("gzip") || stringHeaderName.equalsIgnoreCase("transfer-encoding")) continue;
                httpMethodProxyRequest.setHeader(stringHeaderName, stringHeaderValue);
            }
        }
        return proxyInfo;
    }

    private Map<String, String> splitQuery(String query) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return query_pairs;
    }

    public int getMaxFileUploadSize() {
        return this.maxFileUploadSize;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

