/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.httpproxy;

import it.geosolutions.httpproxy.HttpErrorException;
import it.geosolutions.httpproxy.ProxyCallback;
import it.geosolutions.httpproxy.ProxyConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;

public class MimeTypeChecker
implements ProxyCallback {
    ProxyConfig config;

    public MimeTypeChecker(ProxyConfig config) {
        this.config = config;
    }

    @Override
    public void onRequest(HttpServletRequest request, HttpServletResponse response, URL url) throws IOException {
    }

    @Override
    public void onRemoteResponse(HttpRequestBase method) throws IOException {
        String contentType;
        String firstType;
        Header header;
        Set<String> mimeTypes = this.config.getMimetypeWhitelist();
        if (mimeTypes != null && mimeTypes.size() > 0 && (header = method.getFirstHeader("Content-type")) != null && !mimeTypes.contains(firstType = (contentType = header.getValue()).split(";")[0])) {
            throw new HttpErrorException(403, "Content-type " + firstType + " is not among the ones allowed for this proxy");
        }
    }

    @Override
    public void onFinish() throws IOException {
    }
}

