/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.httpproxy;

import it.geosolutions.httpproxy.HttpErrorException;
import it.geosolutions.httpproxy.ProxyCallback;
import it.geosolutions.httpproxy.ProxyConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class RequestTypeChecker
implements ProxyCallback {
    ProxyConfig config;

    public RequestTypeChecker(ProxyConfig config) {
        this.config = config;
    }

    @Override
    public void onRequest(HttpServletRequest request, HttpServletResponse response, URL url) throws IOException {
        Set<String> reqTypes = this.config.getReqtypeWhitelist();
        if (reqTypes != null && reqTypes.size() > 0) {
            Iterator<String> iterator = reqTypes.iterator();
            String urlExtForm = url.toExternalForm();
            boolean check = false;
            while (iterator.hasNext()) {
                String regex = iterator.next();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(urlExtForm);
                if (!matcher.matches()) continue;
                check = true;
                break;
            }
            if (!check) {
                throw new HttpErrorException(403, "Request Type is not among the ones allowed for this proxy");
            }
        }
    }

    @Override
    public void onRemoteResponse(HttpRequestBase method) throws IOException {
    }

    @Override
    public void onFinish() throws IOException {
    }
}

